/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.dal;

import com.blade.kit.DateKit;
import com.blade.kit.EncryptKit;
import com.blade.kit.PatternKit;
import com.blade.kit.UUID;
import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.zeto.ZenCache;
import com.zeto.ZenEnvironment;
import com.zeto.dal.DBHelper;
import com.zeto.dal.IUserMapper;
import com.zeto.domain.ZenSite;
import com.zeto.domain.ZenUser;
import com.zeto.kit.TagKit;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserMysqlMapper
implements IUserMapper {
    private static final String cacheSuffix = "_user";
    private static final String listColumns = "`_id`,`nick`,`username`,`ukey`,`mobile`,`pwd`,`mkey`,`tag`,`union_id`,`email`";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(ZenUser userDO) {
        String sql = "INSERT INTO `user`(`_id`,`username`,`mobile`,`pwd`,`nick`,`mkey`,`ukey`,`tag`,`union_id`,`email`)VALUES(?,?,?,?,?,?,?,?,?,?)";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, userDO.getUid());
            statement.setString(2, userDO.getUsername());
            statement.setString(3, userDO.getMobile());
            statement.setString(4, userDO.getPwd());
            statement.setString(5, userDO.getNick());
            statement.setString(6, userDO.getMkey());
            statement.setString(7, userDO.getUkey());
            statement.setLong(8, userDO.getTag());
            statement.setString(9, userDO.getUnionId());
            statement.setString(10, userDO.getEmail());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        String sql = "select count(*) from `user`";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ZenUser> select(int start, int size) {
        String sql = "select _id,union_id,nick,tag from `user` limit " + (start *= size) + "," + size;
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ArrayList<ArrayList<ZenUser>> result = new ArrayList<ArrayList<ZenUser>>();
        try {
            ArrayList<ZenUser> zenUser;
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                zenUser = new ZenUser();
                ((ZenUser)((Object)zenUser)).setUid(resultSet.getString(1));
                ((ZenUser)((Object)zenUser)).setUnionId(resultSet.getString(2));
                ((ZenUser)((Object)zenUser)).setNick(resultSet.getString(3));
                ((ZenUser)((Object)zenUser)).setTag(resultSet.getLong(4));
                result.add(zenUser);
            }
            zenUser = result;
            return zenUser;
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ZenUser> search(String keyword, int size) {
        ZenSite site;
        if (Strings.isNullOrEmpty((String)keyword)) {
            return this.select(0, size);
        }
        keyword = "%" + keyword + "%";
        String sql = null;
        if (ZenEnvironment.isMulti() && (site = WebContext.get().getZenSite()) != null) {
            sql = "SELECT user._id,user.nick,user.union_id,user_site.tag FROM `user_site` LEFT JOIN `user` ON user._id=user_site.uid WHERE user_site.site_id='" + site.getId() + "'  AND (user.nick LIKE ? or user.username LIKE ?) LIMIT 0," + size;
        }
        if (sql == null) {
            sql = "SELECT _id,nick,union_id,tag FROM `user` WHERE `nick` LIKE ? or `username` LIKE ? LIMIT 0," + size;
        }
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ArrayList<ArrayList<ZenUser>> result = new ArrayList<ArrayList<ZenUser>>();
        try {
            ArrayList<ZenUser> zenUser;
            statement.setString(1, keyword);
            statement.setString(2, keyword);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                zenUser = new ZenUser();
                ((ZenUser)((Object)zenUser)).setUid(resultSet.getString(1));
                ((ZenUser)((Object)zenUser)).setNick(resultSet.getString(2));
                ((ZenUser)((Object)zenUser)).setUnionId(resultSet.getString(3));
                ((ZenUser)((Object)zenUser)).setTag(resultSet.getLong(4));
                result.add(zenUser);
            }
            zenUser = result;
            dbHelper.close(resultSet);
            return zenUser;
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return null;
    }

    @Override
    public void updateEmail(String email, String uid) {
        this.updateByKey("email", email, uid);
    }

    @Override
    public void updateNick(String nick, String uid) {
        this.updateByKey("nick", nick, uid);
    }

    @Override
    public void updateUionId(String unionId, String uid) {
        this.updateByKey("union_id", unionId, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenUser updateUkey(String uid) {
        String ukey = UUID.captchaNumber(16);
        String sql = "update `user` set ukey=?,ukey_time=? where _id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, ukey);
            statement.setLong(2, DateKit.now());
            statement.setString(3, uid);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
        this.cleanCache(uid);
        return this.get(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTag(String uid, Long tagValue) {
        String sql = "update `user` set tag=? where _id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setLong(1, tagValue);
            statement.setString(2, uid);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
        this.cleanCache(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateByKey(String key, String value, String uid) {
        String sql = "update `user` set " + key + "=? where _id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, value);
            statement.setString(2, uid);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
        this.cleanCache(uid);
    }

    @Override
    public void changePassword(String uid, String pwd) {
        this.updateByKey("pwd", pwd, uid);
        this.updateUkey(uid);
    }

    @Override
    public void cleanCache(String uid) {
        String cacheKey = uid + cacheSuffix;
        ZenCache.remove(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String uid) {
        String sql = "delete from `user` where _id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, uid);
            statement.executeUpdate();
            this.cleanCache(uid);
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exist(String uid) {
        String sql = "select count(*) from `user` where _id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, uid);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                dbHelper.close(resultSet);
                return bl;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existByUnionId(String unionId, int tag) {
        Long tagValue = TagKit.getPositionValue(tag);
        String sql = "select count(*) from `user` where union_id=? and tag&" + tagValue + "=" + tagValue;
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, unionId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                dbHelper.close(resultSet);
                return bl;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return false;
    }

    @Override
    public ZenUser getByUnionId(String unionId, int tagValue) {
        return this.getByRelateId(unionId, "union_id", tagValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZenUser getByRelateId(String relateId, String clm, int tag) {
        Long tagValue = TagKit.getPositionValue(tag);
        String sql = "select `_id`,`nick`,`username`,`ukey`,`mobile`,`pwd`,`mkey`,`tag`,`union_id`,`email` from `user` where " + clm + "=? and tag&" + tagValue + "=" + tagValue;
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ZenUser zenUser = null;
        try {
            statement.setString(1, relateId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                zenUser = this.getUser(resultSet);
            }
            ZenUser zenUser2 = zenUser;
            dbHelper.close(resultSet);
            return zenUser2;
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public ZenUser get(String uid) {
        String cacheKey = uid + cacheSuffix;
        ZenUser zenUser = ZenCache.get(cacheKey, ZenUser.class);
        if (zenUser != null) {
            return zenUser;
        }
        String sql = "select `_id`,`nick`,`username`,`ukey`,`mobile`,`pwd`,`mkey`,`tag`,`union_id`,`email` from `user` where _id=? limit 1";
        return this.get(sql, uid);
    }

    @Override
    public ZenUser getByName(String username) {
        if (Strings.isNullOrEmpty((String)username)) {
            return null;
        }
        String sql = "select `_id`,`nick`,`username`,`ukey`,`mobile`,`pwd`,`mkey`,`tag`,`union_id`,`email` from `user` where username=? limit 1";
        return this.get(sql, username);
    }

    @Override
    public ZenUser getByMobile(String phone, int tag) {
        if (!PatternKit.isPhone(phone)) {
            return null;
        }
        return this.getByRelateId(phone, "mobile", tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZenUser get(String sql, String param) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, param);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ZenUser zenUser = this.getUser(resultSet);
                dbHelper.close(resultSet);
                return zenUser;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return null;
    }

    private ZenUser getUser(ResultSet resultSet) throws SQLException {
        ZenUser zenUser = new ZenUser();
        zenUser.setUid(resultSet.getString(1));
        zenUser.setNick(resultSet.getString(2));
        zenUser.setUsername(resultSet.getString(3));
        zenUser.setMobile(resultSet.getString(5));
        zenUser.setPwd(resultSet.getString(6));
        zenUser.setMkey(resultSet.getString(7));
        zenUser.setTag(resultSet.getLong(8));
        zenUser.setUnionId(resultSet.getString(9));
        zenUser.setEmail(resultSet.getString(10));
        String cacheKey = zenUser.getUid() + cacheSuffix;
        String ukey = EncryptKit.md5(resultSet.getString(4));
        zenUser.setUkey(ukey);
        ZenCache.set(cacheKey, zenUser);
        return zenUser;
    }
}

