/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.dal;

import com.blade.kit.DateKit;
import com.zeto.ZenResult;
import com.zeto.ZenUserKit;
import com.zeto.dal.DBHelper;
import com.zeto.dal.SiteMapper;
import com.zeto.domain.ZenRole;
import com.zeto.domain.ZenSite;
import com.zeto.domain.ZenSiteUser;
import com.zeto.domain.ZenUser;
import com.zeto.kit.TagKit;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserSiteMapper {
    private static final UserSiteMapper instance = new UserSiteMapper();

    public static UserSiteMapper i() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZenResult selectUserWithTag(String siteId, ZenRole role) {
        ZenResult result = ZenResult.success();
        Long tagValue = role.tagValue();
        String sql = "select uid,tag from user_site where site_id=? and (tag&" + tagValue + ")=" + tagValue + " limit 100";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ArrayList<ZenSiteUser> zenUserList = new ArrayList<ZenSiteUser>();
        try {
            statement.setString(1, siteId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ZenSiteUser siteUser = new ZenSiteUser();
                siteUser.setUid(resultSet.getString(1));
                siteUser.setTag(resultSet.getLong(2));
                zenUserList.add(siteUser);
            }
            resultSet.close();
            result.put("list", zenUserList);
            sql = "select count(*) from user_site where site_id=? and (tag&" + tagValue + ")=" + tagValue + " limit 1";
            statement = dbHelper.getStatement(sql);
            statement.setString(1, siteId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                result.put("total", resultSet.getLong(1));
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZenUser> selectAdmins(String siteId) {
        Long tagValue = ZenRole.ADMIN.tagValue();
        String sql = "select uid from user_site where site_id=? and (tag&" + tagValue + ")=" + tagValue + " limit 100";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ArrayList<ZenUser> zenUserList = new ArrayList<ZenUser>();
        try {
            statement.setString(1, siteId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ZenUser user = ZenUserKit.get(resultSet.getString(1));
                zenUserList.add(user);
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return zenUserList;
    }

    public List<ZenSite> selectByUidWithTag(String app, String uid, int position) {
        Long tagData = TagKit.getPositionValue(position);
        String sql = "select site_id from user_site where uid=? and app=? and (tag&" + tagData + ")=" + tagData + " limit 100";
        return this.selectSites(app, uid, sql);
    }

    public List<ZenSite> selectByUid(String app, String uid) {
        Long applicantTag = ZenRole.APPLICANT.tagValue();
        String sql = "select site_id from user_site where uid=? and app=? and (tag&" + applicantTag + ")<>" + applicantTag + " limit 100";
        return this.selectSites(app, uid, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZenSite> selectSites(String app, String uid, String sql) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ArrayList<String> siteIds = new ArrayList<String>();
        try {
            statement.setString(1, uid);
            statement.setString(2, app);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                siteIds.add(resultSet.getString(1));
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return SiteMapper.i().selectByIds(siteIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTag(String uid, String siteId, Long tag) {
        String sql = "update user_site set tag=? where uid=? and site_id=? limit 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setLong(1, tag);
            statement.setString(2, uid);
            statement.setString(3, siteId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZenSiteUser getSiteUser(String uid, String siteId) {
        String sql = "select tag,alias_id,role from user_site where uid=? and site_id=? limit 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, uid);
            statement.setString(2, siteId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ZenSiteUser siteUser = new ZenSiteUser();
                siteUser.setTag(resultSet.getLong(1));
                siteUser.setAliasId(resultSet.getString(2));
                siteUser.setRole(resultSet.getInt(3));
                siteUser.setUid(uid);
                ZenSiteUser zenSiteUser = siteUser;
                dbHelper.close(resultSet);
                return zenSiteUser;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return null;
    }

    public void delete(String uid, String siteId) {
        String sql = "delete from user_site where uid=? and site_id=? limit 1";
        this.execute(sql, uid, siteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(String uid) {
        String sql = "delete from user_site where site_id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, uid);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceId(String uid, String siteId) {
        String sql = "select device_id from user_site where uid=? and site_id=? limit 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, uid);
            statement.setString(2, siteId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                dbHelper.close(resultSet);
                return string;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return null;
    }

    public void updateDeviceId(String uid, String siteId, String deviceId) {
        String sql = "update user_site set device_id='" + deviceId + "' where uid=? and site_id=? limit 1";
        this.execute(sql, uid, siteId);
    }

    public void updateAlias(String uid, String siteId, String aliasId) {
        String sql = "update user_site set alias_id='" + aliasId + "' where uid=? and site_id=? limit 1";
        this.execute(sql, uid, siteId);
    }

    public void updateVisit(String uid, String siteId) {
        String sql = "update user_site set visit_time=" + DateKit.now() + " where uid=? and site_id=? limit 1";
        this.execute(sql, uid, siteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZenUser> selectBySite(String siteId, int page) {
        long tagData = ZenRole.APPLICANT.tagValue();
        int size = 20;
        int start = page * 20;
        String sql = "select uid from user_site where site_id=? and (tag&" + tagData + ")<>" + tagData + " limit " + start + "," + size;
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ArrayList<ZenUser> users = new ArrayList<ZenUser>();
        try {
            statement.setString(1, siteId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ZenUser user = new ZenUser();
                user.setUid(resultSet.getString(1));
                users.add(user);
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countBySite(String siteId) {
        long tagData = ZenRole.APPLICANT.tagValue();
        String sql = "select count(*) from user_site where site_id=? and (tag&" + tagData + ")<>" + tagData + " limit 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, siteId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getInt(1);
                dbHelper.close(resultSet);
                return l;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql, String uid, String siteId) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, uid);
            statement.setString(2, siteId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int count(String uid, String siteId, String sql) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, uid);
            statement.setString(2, siteId);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                dbHelper.close(resultSet);
                return n;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String uid, String siteId, String app, Long tag) {
        DBHelper dbHelper = new DBHelper();
        String sql = "insert into user_site(uid,site_id,tag,app)values(?,?,?,?)";
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, uid);
            statement.setString(2, siteId);
            statement.setLong(3, tag);
            statement.setString(4, app);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }
}

