/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.domain;

import com.zeto.domain.ResponseCode;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private static final long serialVersionUID = -750644833749014690L;
    private boolean hasError = false;
    private T data;
    private int action;
    private String message;

    private Response() {
    }

    public Response<T> setCode(int code, String message) {
        this.action = code;
        this.message = message;
        return this;
    }

    public Response<T> setCode(ResponseCode action, String message) {
        this.action = action.getValue();
        this.message = message;
        return this;
    }

    public Response<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public static <T> Response<T> ok(T data) {
        Response<T> resp = new Response<T>();
        resp.setHasError(false);
        resp.setData(data);
        return resp;
    }

    public static <T> Response<T> ok() {
        return Response.ok(null);
    }

    public static <T> Response<T> fail(String error) {
        Response<T> resp = new Response<T>();
        resp.setMessage(error);
        return resp;
    }

    public static <T> Response<T> fail(String error, int code) {
        Response<T> resp = new Response<T>();
        resp.setHasError(true);
        resp.setAction(code);
        resp.setMessage(error);
        return resp;
    }

    public static <T> Response<T> fail(String error, ResponseCode action) {
        return Response.fail(error, action.getValue());
    }

    public boolean isHasError() {
        return this.hasError;
    }

    public T getData() {
        return this.data;
    }

    public int getAction() {
        return this.action;
    }

    public String getMessage() {
        return this.message;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public String toString() {
        return "Response(hasError=" + this.isHasError() + ", data=" + this.getData() + ", action=" + this.getAction() + ", message=" + this.getMessage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasError() != other.isHasError()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        if (this.getAction() != other.getAction()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasError() ? 79 : 97);
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + this.getAction();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }
}

