/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.domain;

import com.blade.kit.GsonKit;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenSite;
import com.zeto.kit.driver.ConfigVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZenApp
extends ZenSite
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ZenApp.class);
    private String version;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ZenApp() {
    }

    public ZenApp(String content) {
        super(content);
        this.reload();
    }

    public void reload() {
        String path = ZenEnvironment.getPath() + "/config/app.config";
        File file = new File(path);
        if (!file.isFile()) {
            return;
        }
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(filecontent);
            in.close();
            String content = new String(filecontent, "UTF-8");
            List<ConfigVO> configs = GsonKit.parseList(content, ConfigVO.class);
            if (configs == null) {
                return;
            }
            for (int i = 0; i < this.getConfigs().size(); ++i) {
                ConfigVO current = this.getConfigs().get(i);
                for (ConfigVO userConfig : configs) {
                    if (!userConfig.getName().equals(current.getName())) continue;
                    this.getConfigs().set(i, userConfig);
                }
            }
        }
        catch (Exception e) {
            log.error("app config", (Throwable)e);
        }
    }
}

