/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.domain;

import com.google.common.base.Strings;
import com.mongodb.BasicDBObject;
import com.zeto.ZenEnvironment;
import com.zeto.driver.domain.ConditionOperator;
import com.zeto.driver.domain.ConditionVO;
import com.zeto.driver.domain.LeftJoinCondition;
import com.zeto.driver.domain.OrderType;
import com.zeto.driver.domain.OrderVO;
import com.zeto.driver.domain.Table;
import java.util.ArrayList;
import java.util.List;

public abstract class ZenCondition {
    private List<ConditionVO> conditionVOList = new ArrayList<ConditionVO>();
    private String operator;
    private String[] outputs = null;
    private Table table;
    private int limtCount = 20;
    private int skipCount = 0;
    private static final int max = 200;
    private List<OrderVO> orderVOList;

    public int getLimit() {
        if (this.limtCount > 200) {
            return 200;
        }
        return this.limtCount;
    }

    public String getOperator() {
        return this.operator;
    }

    public String[] getOutputs() {
        return this.outputs;
    }

    public List<ConditionVO> getConditions() {
        int size = this.conditionVOList.size();
        for (int i = 0; i < size; ++i) {
            ConditionVO conditionVO = this.conditionVOList.get(i);
            if (!this.table.hasColumn(conditionVO.getName()) || conditionVO.getValue() == null) {
                this.conditionVOList.remove(conditionVO);
                ++i;
                continue;
            }
            if (!this.table.isStringColumn(conditionVO.getName())) continue;
            conditionVO.setString(true);
        }
        return this.conditionVOList;
    }

    public ZenCondition(String operator) {
        this.operator = operator;
    }

    public ZenCondition setTable(String tableName) {
        this.table = ZenEnvironment.getTable(tableName);
        if (this.table == null) {
            try {
                throw new Exception("\u627e\u4e0d\u5230\u8868" + tableName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public ZenCondition add(String key, Object val, ConditionOperator operator) {
        if (val == null) {
            return this;
        }
        ConditionVO conditionVO = new ConditionVO(key, val, operator);
        this.conditionVOList.add(conditionVO);
        return this;
    }

    public ZenCondition eq(String key, Object value) {
        return this.add(key, value, ConditionOperator.Eq);
    }

    public ZenCondition notEq(String key, Object value) {
        return this.add(key, value, ConditionOperator.NotEq);
    }

    public abstract ZenCondition like(String var1, String var2);

    public abstract ZenCondition startWith(String var1, String var2);

    public abstract ZenCondition endWith(String var1, String var2);

    public abstract ZenCondition in(String var1, List<String> var2);

    public abstract ZenCondition notIn(String var1, List<String> var2);

    public ZenCondition greater(String key, Object value) {
        return this.add(key, value, ConditionOperator.Greater);
    }

    public ZenCondition greaterEq(String key, Object value) {
        return this.add(key, value, ConditionOperator.GreaterEq);
    }

    public ZenCondition lesser(String key, Object value) {
        return this.add(key, value, ConditionOperator.Lesser);
    }

    public ZenCondition lesserEq(String key, Object value) {
        return this.add(key, value, ConditionOperator.LesserEq);
    }

    public ZenCondition addOrder(OrderVO orderVO) {
        if (orderVO == null) {
            return this;
        }
        if (this.orderVOList == null) {
            this.orderVOList = new ArrayList<OrderVO>();
        }
        this.orderVOList.add(orderVO);
        return this;
    }

    public ZenCondition setOutputs(String[] outputs) {
        this.outputs = outputs;
        return this;
    }

    public ZenCondition outputs(String ... args) {
        this.outputs = args;
        return this;
    }

    public ZenCondition order(String key, OrderType type) {
        if (this.orderVOList == null) {
            this.orderVOList = new ArrayList<OrderVO>();
        }
        OrderVO orderVO = new OrderVO();
        orderVO.setName(key);
        orderVO.setType(type.getValue());
        this.orderVOList.add(orderVO);
        return this;
    }

    public ZenCondition limit(int count) {
        this.limtCount = count;
        return this;
    }

    public ZenCondition skip(int skip) {
        this.skipCount = skip;
        return this;
    }

    public LeftJoinCondition leftJoin(String rightTable, String leftField, String rightField) {
        return new LeftJoinCondition(rightTable, leftField, rightField, this);
    }

    public Object mgOrder() {
        if (this.orderVOList == null) {
            return null;
        }
        OrderVO orderVO = this.orderVOList.get(0);
        if (orderVO == null || !this.table.hasColumn(orderVO.getName())) {
            return null;
        }
        BasicDBObject sort = new BasicDBObject();
        sort.put((Object)orderVO.getName(), (Object)orderVO.getType());
        return sort;
    }

    public String sqlOrder() {
        if (this.orderVOList == null) {
            return null;
        }
        OrderVO orderVO = this.orderVOList.get(0);
        if (!Strings.isNullOrEmpty((String)orderVO.getName())) {
            if (orderVO.getType() == -1) {
                return " ORDER By `" + orderVO.getName() + "` DESC";
            }
            if (orderVO.getType() == 1) {
                return " ORDER By `" + orderVO.getName() + "` ASC";
            }
        }
        return null;
    }

    public String sqlOrder(String tableName) {
        if (this.orderVOList == null) {
            return null;
        }
        OrderVO orderVO = this.orderVOList.get(0);
        if (!Strings.isNullOrEmpty((String)orderVO.getName())) {
            if (orderVO.getType() == -1) {
                return " ORDER By tableName." + orderVO.getName() + " DESC";
            }
            if (orderVO.getType() == 1) {
                return " ORDER By tableName." + orderVO.getName() + " ASC";
            }
        }
        return null;
    }

    public int getSkip() {
        return this.skipCount;
    }

    public boolean isEmpty() {
        return this.conditionVOList.isEmpty();
    }
}

