/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.domain;

import com.blade.kit.GsonKit;
import com.google.common.base.Strings;
import com.zeto.kit.TagKit;
import com.zeto.kit.driver.ConfigOptionVO;
import com.zeto.kit.driver.ConfigVO;
import com.zeto.kit.driver.OptionValue;
import java.util.ArrayList;
import java.util.List;

public class ZenSite {
    private String id;
    private String title;
    private String domain;
    private String name;
    private String app;
    private String skin;
    private Long tag;
    private List<ConfigVO> configs;

    public ZenSite() {
    }

    public boolean expire() {
        return TagKit.contain(this.tag, 1);
    }

    public ZenSite(String content) {
        if (Strings.isNullOrEmpty((String)content)) {
            this.configs = new ArrayList<ConfigVO>();
            return;
        }
        this.configs = GsonKit.parseList(content, ConfigVO.class);
    }

    public boolean containTag(int tagValue) {
        return TagKit.contain(this.tag, tagValue);
    }

    private ConfigVO configData(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        for (ConfigVO configVO : this.configs) {
            if (!configVO.getName().equals(name)) continue;
            return configVO;
        }
        return null;
    }

    public OptionValue config(String name) {
        ConfigVO configVO = this.configData(name);
        if (configVO == null) {
            return null;
        }
        if (configVO.getType() == 0) {
            return configVO.getValue();
        }
        return null;
    }

    public String config(String name, String key) {
        List<ConfigOptionVO> map = this.group(name);
        if (map == null) {
            return null;
        }
        for (ConfigOptionVO optionVO : map) {
            if (!optionVO.getKey().equals(key)) continue;
            return optionVO.getValue();
        }
        return null;
    }

    public List<ConfigOptionVO> group(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        ConfigVO configVO = this.configData(name);
        if (configVO == null || configVO.getType() != 1) {
            return null;
        }
        return configVO.getOptions();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getApp() {
        return this.app;
    }

    public String getSkin() {
        return this.skin;
    }

    public Long getTag() {
        return this.tag;
    }

    public List<ConfigVO> getConfigs() {
        return this.configs;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public void setTag(Long tag) {
        this.tag = tag;
    }

    public void setConfigs(List<ConfigVO> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZenSite)) {
            return false;
        }
        ZenSite other = (ZenSite)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$skin = this.getSkin();
        String other$skin = other.getSkin();
        if (this$skin == null ? other$skin != null : !this$skin.equals(other$skin)) {
            return false;
        }
        Long this$tag = this.getTag();
        Long other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        List<ConfigVO> this$configs = this.getConfigs();
        List<ConfigVO> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZenSite;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $skin = this.getSkin();
        result = result * 59 + ($skin == null ? 43 : $skin.hashCode());
        Long $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        List<ConfigVO> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "ZenSite(id=" + this.getId() + ", title=" + this.getTitle() + ", domain=" + this.getDomain() + ", name=" + this.getName() + ", app=" + this.getApp() + ", skin=" + this.getSkin() + ", tag=" + this.getTag() + ", configs=" + this.getConfigs() + ")";
    }
}

