/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.domain;

import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.zeto.ZenCache;
import com.zeto.ZenEnvironment;
import com.zeto.ZenSession;
import com.zeto.domain.ZenRole;
import com.zeto.domain.ZenSite;
import com.zeto.kit.SiteKit;
import com.zeto.kit.TagKit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ZenUser
implements Serializable {
    private static final String cacheSuffix = "_user";
    private static final long serialVersionUID = 8157099844869604272L;
    private String uid;
    private String nick;
    private String username = "";
    private String ukey;
    private String mobile = "";
    private String pwd = "";
    private String mkey = "";
    private Long tag = 0L;
    private String unionId;
    private String email;
    private ZenSession _sesion;
    private Map<String, Long> siteTag = null;

    public ZenSession session() {
        if (this._sesion == null) {
            this._sesion = new ZenSession(this.uid);
        }
        return this._sesion;
    }

    public Long getTag(String siteId) {
        if (this.siteTag == null) {
            this.siteTag = new HashMap<String, Long>();
        }
        if (this.siteTag.containsKey(siteId)) {
            return this.siteTag.get(siteId);
        }
        Long tag = SiteKit.getRole(this.uid, siteId);
        this.siteTag.put(siteId, tag);
        this.updateCache();
        return tag;
    }

    public Long getTag() {
        if (ZenEnvironment.isMulti()) {
            String siteId = this.siteId();
            return this.getTag(siteId);
        }
        return this.tag;
    }

    public String siteId() {
        ZenSite site = WebContext.get().getZenSite();
        if (site == null) {
            return null;
        }
        return site.getId();
    }

    public boolean hasTag(ZenRole userTag) {
        Long tag = this.getTag();
        return TagKit.contain(tag, userTag.value()) || TagKit.contain(tag, ZenRole.SUPPER.value());
    }

    public boolean isAdmin() {
        return this.hasTag(ZenRole.ADMIN);
    }

    public void updateCache() {
        String cacheKey = this.uid + cacheSuffix;
        if (Strings.isNullOrEmpty((String)this.ukey) || Strings.isNullOrEmpty((String)this.nick)) {
            return;
        }
        ZenCache.set(cacheKey, this);
    }

    public String avatorPath() {
        String id = this.getUid();
        return String.format("%s/%s/%s.jpg", id.substring(0, 4), id.substring(4, 6), id.substring(6));
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUkey() {
        return this.ukey;
    }

    public void setUkey(String ukey) {
        this.ukey = ukey;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getMkey() {
        return this.mkey;
    }

    public void setMkey(String mkey) {
        this.mkey = mkey;
    }

    public void setTag(Long tag) {
        this.tag = tag;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

