/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver;

import com.google.common.base.Joiner;
import com.mongodb.BasicDBObject;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenCondition;
import com.zeto.driver.domain.ApiData;
import com.zeto.driver.domain.Column;
import com.zeto.driver.domain.ConditionExprVO;
import com.zeto.driver.domain.ConditionVO;
import com.zeto.driver.domain.Table;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class StorageBase {
    private static final int extendIndex = 2;
    protected final int maxSize = 200;
    private static final String AND = "AND";

    protected List<String> getExtendColumns(String tableName) {
        Table table = ZenEnvironment.getTable(tableName);
        if (table == null) {
            return null;
        }
        ArrayList<String> clms = new ArrayList<String>();
        if (table.isExtend()) {
            for (Column column : table.getColumns()) {
                clms.add(column.getName());
            }
        } else {
            for (Column column : table.getColumns()) {
                if (column.getIndex() != 2) continue;
                clms.add(column.getName());
            }
        }
        return clms;
    }

    protected List<String> getColumnsWithoutExtend(String tableName) {
        Table table = ZenEnvironment.getTable(tableName);
        if (table == null) {
            return null;
        }
        ArrayList<String> clms = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            if (column.getIndex() == 2) continue;
            clms.add(column.getName());
        }
        return clms;
    }

    protected void setStatmentConditionByTable(ZenCondition condition, PreparedStatement statement) throws SQLException {
        List<ConditionVO> conditionVOList = condition.getConditions();
        for (int i = 0; i < conditionVOList.size(); ++i) {
            ConditionVO conditionVO = conditionVOList.get(i);
            this.setStatmentParam(i + 1, conditionVO.getValue(), conditionVO.isString(), statement);
        }
    }

    protected void setStatmentCondition(ApiData apiData, PreparedStatement statement) throws SQLException {
        List<ConditionExprVO> params = apiData.getWhere().getValues();
        Table table = ZenEnvironment.getTable(apiData.getTableName());
        for (int i = 0; i < params.size(); ++i) {
            ConditionExprVO exprVO = params.get(i);
            this.setStatmentParam(i + 1, exprVO.getValue(), table.isStringColumn(exprVO.getColumn()), statement);
        }
    }

    protected void setStatmentParam(int index, Object value, boolean isString, PreparedStatement statement) throws SQLException {
        if (isString) {
            statement.setString(index, value.toString());
        } else if (value == null) {
            statement.setLong(index, 0L);
        } else {
            statement.setLong(index, Long.valueOf(value.toString()));
        }
    }

    protected String conditionToSQL(ZenCondition condition) {
        ArrayList<String> exprs = new ArrayList<String>();
        for (ConditionVO conditionVO : condition.getConditions()) {
            exprs.add(conditionVO.sqlExpr());
        }
        return Joiner.on((String)(" " + condition.getOperator() + " ")).join(exprs);
    }

    protected String conditionOnSQL(ZenCondition condition) {
        List<ConditionVO> conditions = condition.getConditions();
        if (conditions.size() == 0) {
            return null;
        }
        ArrayList<String> exprs = new ArrayList<String>();
        String table = condition.getTable().getName();
        for (ConditionVO conditionVO : conditions) {
            exprs.add(table + "." + conditionVO.sqlExpr());
        }
        return Joiner.on((String)(" " + condition.getOperator() + " ")).join(exprs);
    }

    protected BasicDBObject getMatch(ZenCondition condition) {
        List<ConditionVO> conditionVOList = condition.getConditions();
        int size = conditionVOList.size();
        if (size == 0) {
            return null;
        }
        CharSequence[] matchs = new String[size];
        for (int i = 0; i < size; ++i) {
            ConditionVO conditionVO = conditionVOList.get(i);
            matchs[i] = conditionVO.getName() + ":" + conditionVO.mgValue();
        }
        String bson = "{$match:{" + String.join((CharSequence)",", String.join((CharSequence)",", matchs)) + "}}";
        return BasicDBObject.parse((String)bson);
    }

    protected BasicDBObject conditionToBson(ZenCondition condition) {
        List<ConditionVO> conditionVOList = condition.getConditions();
        int size = conditionVOList.size();
        if (size == 0) {
            return null;
        }
        CharSequence[] conds = new String[size];
        for (int i = 0; i < size; ++i) {
            ConditionVO conditionVO = conditionVOList.get(i);
            conds[i] = String.format("{%s:%s}", conditionVO.getName(), conditionVO.mgValue());
        }
        String bson = size == 1 ? conds[0] : (condition.getOperator().equals(AND) ? "{$and:[" + String.join((CharSequence)",", conds) + "]}" : "{$or:[" + String.join((CharSequence)",", conds) + "]}");
        return BasicDBObject.parse((String)bson);
    }
}

