/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver;

import com.blade.kit.StringKit;
import com.google.common.base.Strings;
import com.zeto.ZenConditionKit;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.dal.ApiMapper;
import com.zeto.domain.ZenCondition;
import com.zeto.domain.ZenUser;
import com.zeto.driver.IReadService;
import com.zeto.driver.IWriteService;
import com.zeto.driver.domain.ApiData;
import com.zeto.driver.domain.LeftJoinCondition;
import com.zeto.driver.domain.Table;
import com.zeto.driver.mix.MixDailyExecutor;
import com.zeto.driver.mix.MixExecutor;
import com.zeto.driver.mongodb.MgReadService;
import com.zeto.driver.mongodb.MgWriteService;
import com.zeto.driver.mysql.MysqlReadService;
import com.zeto.driver.mysql.MysqlWriteService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ZenStorageEngine {
    private static IReadService readService;
    private static IWriteService writeService;
    private static final MixExecutor mixExecutor;
    private static final MixDailyExecutor mixDailyExecutor;
    private static final String PAGE_KEY = "page";
    private static final String SIZE_KEY = "size";
    private static final String ID_KEY = "_id";
    private static final String LIST_KEY = "_z_";
    private static final String LIKE_KEY = "lk_";
    private static final int KEY_LENGTH = 3;
    private static final String GREATER_KEY = "gt_";
    private static final String LESSER_KEY = "ls_";

    public void init() {
        if (ZenEnvironment.isCloudApp()) {
            readService = new MgReadService();
            writeService = new MgWriteService();
        } else {
            readService = new MysqlReadService();
            writeService = new MysqlWriteService();
        }
    }

    public ZenResult execute(String path, ZenData data, ZenUser user) {
        String action = path.substring(0, path.indexOf("/"));
        if (action.equals("mix")) {
            return mixExecutor.execute(path, data, user, ZenEnvironment.getAppName());
        }
        ApiData apiData = ApiMapper.i().getApiByName(ZenEnvironment.getAppName(), path);
        if (apiData == null) {
            return ZenResult.fail("\u670d\u52a1\u4e0d\u5b58\u5728");
        }
        if (apiData.getRole() != 0 && user == null) {
            return ZenResult.noLogin();
        }
        apiData.prepare(data, user, action.equals("create"));
        return this.execute(user, data, apiData, action);
    }

    public ZenResult executeWithDaily(String path, ZenData data, ZenUser user, String appName) {
        if (ZenEnvironment.isOnline()) {
            return ZenResult.fail("\u53ea\u80fd\u5728\u65e5\u5e38\u73af\u5883\u6267\u884c");
        }
        String action = path.substring(0, path.indexOf("/"));
        if (action.equals("mix")) {
            return mixDailyExecutor.execute(path, data, user, appName);
        }
        ApiData apiData = ApiMapper.i().getApiByName(appName, path);
        if (apiData == null) {
            return ZenResult.fail("\u670d\u52a1\u4e0d\u5b58\u5728");
        }
        Table table = ZenEnvironment.getTableByApp(apiData.getName(), appName);
        apiData.prepare(data, user, action.equals("put"), table);
        return this.execute(user, data, apiData, action);
    }

    public ZenResult delete(String tableName, ZenCondition condition) {
        condition.setTable(tableName);
        return writeService.delete(tableName, condition);
    }

    public ZenResult update(String tableName, ZenData data, ZenCondition condition) {
        condition.setTable(tableName);
        return writeService.patch(tableName, data, condition);
    }

    public ZenResult select(String tableName, ZenCondition condition) {
        condition.setTable(tableName);
        return readService.select(tableName, condition);
    }

    public ZenResult select(String tableName, int page, int pageSize) {
        return readService.select(tableName, page, pageSize);
    }

    public long count(String tableName) {
        return readService.count(tableName);
    }

    public long count(String tableName, ZenCondition condition) {
        condition.setTable(tableName);
        return readService.count(tableName, condition);
    }

    public boolean exist(String tableName, String _id) {
        long count = readService.count(tableName, ZenConditionKit.And().setTable(tableName).eq(ID_KEY, _id));
        return count > 0L;
    }

    public long sum(String column, String tableName) {
        return readService.sum(column, tableName);
    }

    public long sum(String column, String tableName, ZenCondition condition) {
        return readService.sum(column, tableName, condition.setTable(tableName));
    }

    public ZenResult selectByIds(String table, String[] ids) {
        Table zenTable = ZenEnvironment.getTable(table);
        if (zenTable == null) {
            return ZenResult.error("\u627e\u4e0d\u5230\u8868" + table);
        }
        if (ids == null || ids.length == 0) {
            return ZenResult.success();
        }
        if (zenTable.isExtend()) {
            return ZenResult.success();
        }
        return readService.selectByIds(table, ids);
    }

    public ZenResult selectByIds(String table, String relateId, ZenResult source, String[] mergeKeys) {
        if (source.isEmpty()) {
            return ZenResult.success().emptyArray();
        }
        List<Object> list = source.getList();
        int length = list.size();
        if (length == 0) {
            return ZenResult.success().emptyArray();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            Map itemObj = (Map)list.get(i);
            String id = (String)itemObj.get(relateId);
            if (id == null) continue;
            ids.add(id);
        }
        String[] arr = new String[ids.size()];
        ZenResult result = this.selectByIds(table, ids.toArray(arr));
        if (result.isEmpty()) {
            return result;
        }
        for (Object item : result.getList()) {
            Map current = (Map)item;
            for (Object sourceItem : source.getList()) {
                Map sourceData = (Map)sourceItem;
                if (current.get(ID_KEY).equals(sourceData.get(relateId))) {
                    current.put("_source", sourceData.get(ID_KEY));
                }
                if (mergeKeys == null) continue;
                for (String key : mergeKeys) {
                    current.put(key, sourceData.get(key));
                }
            }
        }
        return result;
    }

    public ZenResult selectByIds(String table, String relateId, ZenResult source) {
        return this.selectByIds(table, relateId, source, null);
    }

    public ZenResult get(String tableName, String _id) {
        return readService.get(_id, tableName);
    }

    public ZenResult get(String tableName, ZenCondition condition) {
        ZenResult result = readService.select(tableName, condition.setTable(tableName).limit(1));
        List<Map<String, Object>> data = result.getListWidthMap();
        if (data == null || data.size() == 0) {
            return ZenResult.success();
        }
        return ZenResult.success().setData(data.get(0));
    }

    public ZenResult leftJoin(String tableName, LeftJoinCondition leftJoinCondition) {
        leftJoinCondition.leftTable(tableName);
        if (leftJoinCondition.getRightCondition() == null) {
            return ZenResult.fail("\u53f3\u8868\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return readService.leftJoin(tableName, leftJoinCondition);
    }

    public ZenResult listWithPage(String path, ZenData data, ZenUser user) {
        ApiData apiData = ApiMapper.i().getApiByName(ZenEnvironment.getAppName(), path);
        if (apiData == null) {
            return ZenResult.fail(path + "\u63a5\u53e3\u4e0d\u5b58\u5728");
        }
        if (apiData.getRole() != 0 && user == null) {
            return ZenResult.noPermision();
        }
        apiData.prepare(data, user, false);
        return this.listWithPage(data, apiData);
    }

    public ZenResult listWithPage(String tableName, ZenCondition condition) {
        condition.setTable(tableName);
        ZenResult list = readService.select(tableName, condition);
        long total = readService.count(tableName, condition);
        return ZenResult.success().put("list", list.getData()).put("total", total);
    }

    private ZenResult listWithPage(ZenData data, ApiData apiData) {
        int page = data.getInt(PAGE_KEY, 0);
        int pageSize = data.getInt(SIZE_KEY, 20);
        String tableName = apiData.getTableName();
        data.remove(PAGE_KEY);
        data.remove(SIZE_KEY);
        data.remove(LIST_KEY);
        ZenCondition condition = apiData.getWhere().zenCondition().setTable(tableName).skip(page * pageSize).limit(pageSize).addOrder(apiData.getOrder());
        for (String key : data.getKeys()) {
            String itemValue = data.get(key);
            if (Strings.isNullOrEmpty((String)itemValue)) continue;
            if (key.startsWith(LIKE_KEY)) {
                condition.like(key.substring(3), itemValue);
                continue;
            }
            if (key.startsWith(GREATER_KEY)) {
                condition.greater(key.substring(3), itemValue);
                continue;
            }
            if (key.startsWith(LESSER_KEY)) {
                condition.lesser(key.substring(3), itemValue);
                continue;
            }
            condition.eq(key, itemValue);
        }
        ZenResult list = readService.select(tableName, apiData.outputParams(), condition);
        long total = readService.count(tableName, condition);
        return ZenResult.success().put("list", list.getData()).put("total", total);
    }

    public ZenResult execute(ZenUser user, ZenData data, ApiData apiData, String action) {
        String checkTypeMessage = apiData.checkType();
        if (StringKit.isNotBlank(checkTypeMessage)) {
            return ZenResult.fail(checkTypeMessage);
        }
        switch (action) {
            case "select": {
                if (data.contains(LIST_KEY)) {
                    return this.listWithPage(data, apiData);
                }
                int page = data.getInt(PAGE_KEY, 0);
                int pageSize = data.getInt(SIZE_KEY, 20);
                return readService.getList(apiData, page, pageSize);
            }
            case "count": {
                return ZenResult.success().setData(readService.count(apiData));
            }
            case "put": {
                if (Strings.isNullOrEmpty((String)apiData.fieldValueByName(ID_KEY))) {
                    return ZenResult.fail("\u4e3b\u952e_id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ZenResult origin = writeService.put(apiData);
                if (!origin.isSuccess()) {
                    return origin;
                }
                return this.reback(origin, data, apiData.outputParams());
            }
            case "patch": {
                ZenResult origin = writeService.patch(apiData);
                if (!origin.isSuccess()) {
                    return origin;
                }
                return this.reback(origin, data, apiData.outputParams()).setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            }
            case "get": {
                return readService.get(apiData);
            }
            case "delete": {
                String primaryId = apiData.primary();
                String tableName = apiData.getTableName();
                if (primaryId != null && !ZenEnvironment.isLocalApp()) {
                    ZenResult origin = readService.get(primaryId, tableName);
                    if (origin.isEmpty()) {
                        return ZenResult.success();
                    }
                    if (user == null) {
                        return ZenResult.fail("user\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                return writeService.delete(apiData);
            }
        }
        return ZenResult.fail("\u63a5\u53e3\u4e0d\u5b58\u5728");
    }

    public ZenResult extend(String tableName, String _id) {
        return ZenResult.success();
    }

    private ZenResult reback(ZenResult result, ZenData params, List<String> outputs) {
        for (String key : outputs) {
            result.put(key, params.get(key));
        }
        return result;
    }

    static {
        mixExecutor = new MixExecutor();
        mixDailyExecutor = new MixDailyExecutor();
    }
}

