/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.cache;

import com.blade.kit.DateKit;
import com.google.common.base.Strings;
import com.zeto.dal.DBHelper;
import com.zeto.driver.cache.ICache;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CacheMapper
implements ICache {
    private static CacheMapper cacheMapper = new CacheMapper();

    private CacheMapper() {
    }

    public static CacheMapper I() {
        return cacheMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        long time = DateKit.now() - 600L;
        String sql = "delete from `cache` where create_time<?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setLong(1, time);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String cacheId) {
        String sql = "delete from `cache` where id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, cacheId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String cacheId, String content, Integer minutes) {
        if (Strings.isNullOrEmpty((String)content) || Strings.isNullOrEmpty((String)cacheId)) {
            return;
        }
        this.remove(cacheId);
        String sql = "INSERT INTO `cache`(id,content,create_time)VALUES(?,?,?)";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, cacheId);
            statement.setString(2, content);
            statement.setLong(3, DateKit.now() + (long)(minutes * 60));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String cacheId) {
        ResultSet resultSet;
        DBHelper dbHelper;
        block5: {
            String content;
            block6: {
                String sql = "SELECT `content`,`create_time` FROM `cache` WHERE id=?";
                dbHelper = new DBHelper();
                PreparedStatement statement = dbHelper.getStatement(sql);
                resultSet = null;
                statement.setString(1, cacheId);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block5;
                content = resultSet.getString(1);
                long createTime = resultSet.getLong(2);
                if (DateKit.now() <= createTime) break block6;
                this.remove(cacheId);
                String string = null;
                dbHelper.close(resultSet);
                return string;
            }
            try {
                String string = content;
                dbHelper.close(resultSet);
                return string;
            }
            catch (SQLException e) {
                try {
                    dbHelper.close(e);
                    dbHelper.close(resultSet);
                }
                catch (Throwable throwable) {
                    dbHelper.close(resultSet);
                    throw throwable;
                }
            }
        }
        dbHelper.close(resultSet);
        return null;
    }
}

