/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.cache;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zeto.driver.cache.ICache;
import java.util.concurrent.TimeUnit;

public class GuavaCache
implements ICache {
    Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(20000L).initialCapacity(1000).expireAfterAccess(60L, TimeUnit.MINUTES).build();

    @Override
    public void remove(String cacheId) {
        this.cache.invalidate((Object)cacheId);
    }

    @Override
    public void set(String cacheId, String content, Integer minutes) {
        if (Strings.isNullOrEmpty((String)content) || Strings.isNullOrEmpty((String)cacheId)) {
            return;
        }
        this.cache.put((Object)cacheId, (Object)content);
    }

    @Override
    public String get(String cacheId) {
        return (String)this.cache.getIfPresent((Object)cacheId);
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }
}

