/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.cache;

import com.google.common.base.Strings;
import com.zeto.driver.cache.ICache;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memcache
implements ICache {
    private static final Logger log = LoggerFactory.getLogger(Memcache.class);
    private MemcachedClient cache = null;

    public Memcache(String host) {
        try {
            this.cache = new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), AddrUtil.getAddresses((String)host));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void remove(String cacheId) {
        this.cache.delete(cacheId);
    }

    @Override
    public void set(String cacheId, String content, Integer minutes) {
        if (Strings.isNullOrEmpty((String)content) || Strings.isNullOrEmpty((String)cacheId)) {
            return;
        }
        try {
            int exp = minutes * 60;
            this.cache.set(cacheId, exp, (Object)content);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public String get(String cacheId) {
        Object result = this.cache.get(cacheId);
        if (result == null) {
            return null;
        }
        return (String)result;
    }

    @Override
    public void close() {
        this.cache.shutdown();
    }
}

