/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.domain;

import com.blade.kit.DateKit;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenSite;
import com.zeto.domain.ZenUser;
import com.zeto.driver.domain.Column;
import com.zeto.driver.domain.Condition;
import com.zeto.driver.domain.ConditionExprVO;
import com.zeto.driver.domain.ConsoleType;
import com.zeto.driver.domain.InputVO;
import com.zeto.driver.domain.OrderVO;
import com.zeto.driver.domain.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ApiData
implements Serializable {
    private static final int maxLimit = 100;
    private static final int consoleType = 2;
    private String name;
    private String title;
    private String type;
    private int role;
    private boolean isExtend = false;
    private boolean slient = false;
    private String tableName;
    private List<InputVO> params;
    private String[] outputs = new String[0];
    private int limit = 1;
    private Condition where;
    private OrderVO order;
    private Table table;

    public List<String> outputParams() {
        ArrayList<String> params = new ArrayList<String>();
        for (String param : this.outputs) {
            if (!this.table.hasColumn(param)) continue;
            params.add(param);
        }
        return params;
    }

    public String checkType() {
        if (this.getParams() == null) {
            return null;
        }
        for (InputVO inputVO : this.getParams()) {
            String result = inputVO.check();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void prepare(ZenData data, ZenUser user, boolean isPut) {
        this.table = ZenEnvironment.getTable(this.tableName);
        this.prepare(data, user, isPut, this.table);
    }

    public void prepare(ZenData data, ZenUser user, boolean isPut, Table table) {
        this.table = table;
        if (table.isExtend()) {
            this.setExtend(true);
        }
        if (this.where != null) {
            this.setConditionValue(this.where.getExprs(), data, user);
        }
        if (this.getParams() == null) {
            return;
        }
        int paramsSize = this.getParams().size();
        for (int i = 0; i < paramsSize; ++i) {
            InputVO inputVO = this.getParams().get(i);
            String columnName = inputVO.getName();
            Column clm = table.column(columnName);
            if (clm == null) {
                this.getParams().remove(i);
                --paramsSize;
                --i;
                continue;
            }
            if (clm.getIndex() > 0) {
                inputVO.setIndex(clm.getIndex());
            }
            inputVO.setType(clm.getType());
            inputVO.setLength(clm.getLength());
            if (inputVO.getFrom().equals(2)) {
                String value = this.consoleValue(inputVO, user, data);
                inputVO.setValue(value);
                continue;
            }
            if (!isPut && !data.contains(columnName)) {
                this.getParams().remove(i);
                --paramsSize;
                --i;
                continue;
            }
            if (!data.contains(columnName)) continue;
            inputVO.setValue(data.get(columnName));
        }
    }

    public String primary() {
        if (this.getParams() != null) {
            for (InputVO field : this.getParams()) {
                if (!field.getName().equals("_id")) continue;
                return field.getValue();
            }
        }
        return this.where.primary();
    }

    public String fieldValueByName(String name) {
        for (InputVO field : this.getParams()) {
            if (!field.getName().equals(name)) continue;
            return field.getValue();
        }
        return null;
    }

    public int getLimit() {
        if (this.limit > 100) {
            this.setLimit(100);
        }
        return this.limit;
    }

    private void setConditionValue(ConditionExprVO[] exprs, ZenData data, ZenUser user) {
        if (exprs == null) {
            return;
        }
        for (ConditionExprVO exprVO : exprs) {
            if (exprVO.getCondition() != null) {
                this.setConditionValue(exprVO.getCondition().getExprs(), data, user);
                continue;
            }
            if (exprVO.getFrom() == 2) {
                String value = this.consoleValue(exprVO.getValue(), user);
                exprVO.setValue(value);
                continue;
            }
            String varName = exprVO.getVarName();
            if (!data.contains(varName)) continue;
            exprVO.setValue(data.get(varName));
        }
    }

    private String consoleValue(String fieldName, ZenUser user) {
        if (fieldName.equals(ConsoleType.AutoId.getValue())) {
            return StringKit.objectId();
        }
        if (fieldName.equals(ConsoleType.UserId.getValue())) {
            if (user == null) {
                return null;
            }
            return user.getUid();
        }
        if (fieldName.equals(ConsoleType.Current.getValue())) {
            return DateKit.now() + "";
        }
        if (fieldName.equals(ConsoleType.DATE.getValue())) {
            return DateKit.today() + "";
        }
        if (fieldName.equals(ConsoleType.SiteId.getValue())) {
            ZenSite site = WebContext.get().getZenSite();
            if (site == null) {
                return null;
            }
            return site.getId();
        }
        return null;
    }

    private String consoleValue(InputVO inputVO, ZenUser user, ZenData data) {
        String val;
        String fieldName = inputVO.getValue();
        String varName = inputVO.getName();
        if (fieldName.equals(ConsoleType.AutoId.getValue()) && Strings.isNullOrEmpty((String)varName) && data.contains(varName) && !Strings.isNullOrEmpty((String)(val = data.get(varName)))) {
            return data.get(varName);
        }
        String value = this.consoleValue(fieldName, user);
        data.put(varName, value);
        return value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiData)) {
            return false;
        }
        ApiData other = (ApiData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getRole() != other.getRole()) {
            return false;
        }
        if (this.isExtend() != other.isExtend()) {
            return false;
        }
        if (this.isSlient() != other.isSlient()) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        List<InputVO> this$params = this.getParams();
        List<InputVO> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOutputs(), other.getOutputs())) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        Condition this$where = this.getWhere();
        Condition other$where = other.getWhere();
        if (this$where == null ? other$where != null : !((Object)this$where).equals(other$where)) {
            return false;
        }
        OrderVO this$order = this.getOrder();
        OrderVO other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + this.getRole();
        result = result * 59 + (this.isExtend() ? 79 : 97);
        result = result * 59 + (this.isSlient() ? 79 : 97);
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        List<InputVO> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOutputs());
        result = result * 59 + this.getLimit();
        Condition $where = this.getWhere();
        result = result * 59 + ($where == null ? 43 : ((Object)$where).hashCode());
        OrderVO $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public int getRole() {
        return this.role;
    }

    public boolean isExtend() {
        return this.isExtend;
    }

    public boolean isSlient() {
        return this.slient;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<InputVO> getParams() {
        return this.params;
    }

    public String[] getOutputs() {
        return this.outputs;
    }

    public Condition getWhere() {
        return this.where;
    }

    public OrderVO getOrder() {
        return this.order;
    }

    public Table getTable() {
        return this.table;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public void setExtend(boolean isExtend) {
        this.isExtend = isExtend;
    }

    public void setSlient(boolean slient) {
        this.slient = slient;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setParams(List<InputVO> params) {
        this.params = params;
    }

    public void setOutputs(String[] outputs) {
        this.outputs = outputs;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setWhere(Condition where) {
        this.where = where;
    }

    public void setOrder(OrderVO order) {
        this.order = order;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String toString() {
        return "ApiData(name=" + this.getName() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", role=" + this.getRole() + ", isExtend=" + this.isExtend() + ", slient=" + this.isSlient() + ", tableName=" + this.getTableName() + ", params=" + this.getParams() + ", outputs=" + Arrays.deepToString(this.getOutputs()) + ", limit=" + this.getLimit() + ", where=" + this.getWhere() + ", order=" + this.getOrder() + ", table=" + this.getTable() + ")";
    }
}

