/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.zeto.ZenConditionKit;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenCondition;
import com.zeto.driver.domain.ConditionExprVO;
import com.zeto.driver.domain.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Condition
implements Serializable {
    private String relate;
    private ConditionExprVO[] exprs;
    private List<ConditionExprVO> values;

    public String primary() {
        for (ConditionExprVO exprVO : this.exprs) {
            if (!exprVO.getColumn().equals("_id")) continue;
            return exprVO.getValue();
        }
        return null;
    }

    public ZenCondition zenCondition() {
        ZenCondition condition = ZenConditionKit.And();
        if (this.getExprs() == null) {
            return condition;
        }
        for (ConditionExprVO exprVO : this.getExprs()) {
            if (Strings.isNullOrEmpty((String)exprVO.getColumn()) || exprVO.getValue() == null) continue;
            if (exprVO.getOperator() == 0) {
                condition.eq(exprVO.getColumn(), exprVO.getValue());
            }
            if (exprVO.getOperator() == 1) {
                condition.greater(exprVO.getColumn(), exprVO.getValue());
            }
            if (exprVO.getOperator() == 2) {
                condition.greaterEq(exprVO.getColumn(), exprVO.getValue());
            }
            if (exprVO.getOperator() == 3) {
                condition.lesser(exprVO.getColumn(), exprVO.getValue());
            }
            if (exprVO.getOperator() == 4) {
                condition.lesserEq(exprVO.getColumn(), exprVO.getValue());
            }
            if (exprVO.getOperator() == 5) {
                condition.like(exprVO.getColumn(), exprVO.getValue());
            }
            if (exprVO.getOperator() != 6) continue;
            condition.notEq(exprVO.getColumn(), exprVO.getValue());
        }
        return condition;
    }

    public String SQL() {
        if (this.getExprs() == null) {
            return null;
        }
        this.values = new ArrayList<ConditionExprVO>();
        ArrayList<String> result = new ArrayList<String>();
        for (ConditionExprVO exprVO : this.getExprs()) {
            if (Strings.isNullOrEmpty((String)exprVO.getColumn()) || exprVO.getValue() == null) continue;
            result.add(exprVO.sqlExpr());
            this.values.add(exprVO);
        }
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return (String)result.get(0);
        }
        if (this.getRelate().equals("OR")) {
            return Joiner.on((String)" OR ").join(result);
        }
        return Joiner.on((String)" AND ").join(result);
    }

    public Bson MgCondition(String tableName) {
        if (this.getExprs() == null) {
            return null;
        }
        Table table = ZenEnvironment.getTable(tableName);
        ArrayList<String> exrList = new ArrayList<String>();
        for (ConditionExprVO exprVO : this.getExprs()) {
            String expStr;
            if (Strings.isNullOrEmpty((String)exprVO.getColumn()) || exprVO.getValue() == null || (expStr = exprVO.mgExpr(table.isStringColumn(exprVO.getColumn()))) == null) continue;
            exrList.add(expStr);
        }
        if (exrList.size() == 0) {
            return null;
        }
        String bson = Joiner.on((char)',').join(exrList);
        if (this.getExprs().length > 1) {
            bson = this.getRelate().equals("OR") ? "{$or:[" + bson + "]}" : "{$and:[" + bson + "]}";
        }
        return Document.parse((String)bson);
    }

    public String getRelate() {
        return this.relate;
    }

    public ConditionExprVO[] getExprs() {
        return this.exprs;
    }

    public List<ConditionExprVO> getValues() {
        return this.values;
    }

    public void setRelate(String relate) {
        this.relate = relate;
    }

    public void setExprs(ConditionExprVO[] exprs) {
        this.exprs = exprs;
    }

    public void setValues(List<ConditionExprVO> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$relate = this.getRelate();
        String other$relate = other.getRelate();
        if (this$relate == null ? other$relate != null : !this$relate.equals(other$relate)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExprs(), other.getExprs())) {
            return false;
        }
        List<ConditionExprVO> this$values = this.getValues();
        List<ConditionExprVO> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Condition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $relate = this.getRelate();
        result = result * 59 + ($relate == null ? 43 : $relate.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getExprs());
        List<ConditionExprVO> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "Condition(relate=" + this.getRelate() + ", exprs=" + Arrays.deepToString(this.getExprs()) + ", values=" + this.getValues() + ")";
    }
}

