/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.domain;

import com.blade.kit.GsonKit;
import com.zeto.driver.domain.ConditionOperator;
import java.util.regex.Pattern;

public class ConditionVO {
    private String name;
    private Object value;
    private ConditionOperator operator;
    private boolean isString = false;

    public ConditionVO(String name, Object value, ConditionOperator operator) {
        this.name = name;
        this.value = value;
        this.operator = operator;
    }

    public String mgValue() {
        if (this.operator.equals((Object)ConditionOperator.Eq)) {
            return this.isString ? "\"" + this.value + "\"" : this.value.toString();
        }
        if (this.operator.equals((Object)ConditionOperator.NotEq)) {
            String val = this.isString ? "\"" + this.value + "\"" : this.value.toString();
            return "{$ne:" + val + "}";
        }
        if (this.operator.equals((Object)ConditionOperator.Like)) {
            Pattern pattern = Pattern.compile("^.*" + this.value + ".*$", 2);
            return "/" + pattern.toString() + "/";
        }
        if (this.operator.equals((Object)ConditionOperator.In)) {
            return "{$in:" + GsonKit.stringify(this.value) + "}";
        }
        if (this.operator.equals((Object)ConditionOperator.NotIn)) {
            return "{$nin:" + GsonKit.stringify(this.value) + "}";
        }
        if (this.operator.equals((Object)ConditionOperator.StartWith)) {
            Pattern pattern = Pattern.compile("^" + this.value + ".*$", 2);
            return "/" + pattern.toString() + "/";
        }
        if (this.operator.equals((Object)ConditionOperator.EndWith)) {
            Pattern pattern = Pattern.compile("^.*" + this.value + "$", 2);
            return "/" + pattern.toString() + "/";
        }
        if (this.operator.equals((Object)ConditionOperator.Greater)) {
            return "{$gt:" + this.value + "}";
        }
        if (this.operator.equals((Object)ConditionOperator.GreaterEq)) {
            return "{$gte:" + this.value + "}";
        }
        if (this.operator.equals((Object)ConditionOperator.Lesser)) {
            return "{$lt:" + this.value + "}";
        }
        if (this.operator.equals((Object)ConditionOperator.LesserEq)) {
            return "{$lte:" + this.value + "}";
        }
        return null;
    }

    public String sqlExpr() {
        if (this.operator.equals((Object)ConditionOperator.Eq)) {
            return "`" + this.name + "`=?";
        }
        if (this.operator.equals((Object)ConditionOperator.NotEq)) {
            return "`" + this.name + "`<>?";
        }
        if (this.operator.equals((Object)ConditionOperator.Like) || this.operator.equals((Object)ConditionOperator.StartWith) || this.operator.equals((Object)ConditionOperator.EndWith)) {
            return "`" + this.name + "` like ?";
        }
        if (this.operator.equals((Object)ConditionOperator.In)) {
            return "`" + this.name + "` in ?";
        }
        if (this.operator.equals((Object)ConditionOperator.NotIn)) {
            return "`" + this.name + "` not in ?";
        }
        if (this.operator.equals((Object)ConditionOperator.Greater)) {
            return "`" + this.name + "`>?";
        }
        if (this.operator.equals((Object)ConditionOperator.GreaterEq)) {
            return "`" + this.name + "`>=?";
        }
        if (this.operator.equals((Object)ConditionOperator.Lesser)) {
            return "`" + this.name + "`<?";
        }
        if (this.operator.equals((Object)ConditionOperator.LesserEq)) {
            return "`" + this.name + "`<=?";
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isString() {
        return this.isString;
    }

    public void setString(boolean isString) {
        this.isString = isString;
    }
}

