/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.domain;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;

public enum DataType {
    LONG(1, "\u6574\u5f62"),
    STRING(2, "\u5b57\u7b26\u4e32"),
    DOUBLE(3, "\u6d6e\u70b9\u578b"),
    BOOLEAN(4, "\u5e03\u5c14\u578b"),
    AUTOID(5, "\u81ea\u589eID"),
    DATE(6, "\u65e5\u671f"),
    MONEY(7, "\u91d1\u989d"),
    USER(8, "User\u5bf9\u8c61"),
    PIRMARY(9, "\u4e3b\u952e\u5bf9\u8c61"),
    FILE(10, "\u6587\u4ef6\u7c7b\u578b"),
    IMAGE(11, "\u56fe\u7247\u7c7b\u578b");

    private Integer value;
    private String name;

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private DataType(Integer value, String name) {
        this.value = value;
        this.name = name;
    }

    public static String getSqliteType(int value, int length) {
        if (LONG.getValue().equals(value)) {
            return "INTEGER";
        }
        if (STRING.getValue().equals(value)) {
            return "TEXT";
        }
        if (DATE.getValue().equals(value)) {
            return "INTEGER";
        }
        if (DOUBLE.getValue().equals(value)) {
            return "REAL";
        }
        if (AUTOID.getValue().equals(value)) {
            return "TEXT";
        }
        if (MONEY.getValue().equals(value)) {
            return "REAL";
        }
        if (USER.getValue().equals(value)) {
            return "TEXT";
        }
        if (PIRMARY.getValue().equals(value)) {
            return "TEXT";
        }
        if (FILE.getValue().equals(value)) {
            return "BLOB";
        }
        if (IMAGE.getValue().equals(value)) {
            return "BLOB";
        }
        return "";
    }

    public static String getDBType(Integer value, int length) {
        if (LONG.getValue().equals(value)) {
            return "bigint(20)";
        }
        if (STRING.getValue().equals(value)) {
            if (length > 1024) {
                return "longtext";
            }
            if (length < 32) {
                return "char(" + length + ")";
            }
            return "varchar(" + length + ")";
        }
        if (DATE.getValue().equals(value)) {
            return "bigint(20)";
        }
        if (DOUBLE.getValue().equals(value)) {
            return "float";
        }
        if (AUTOID.getValue().equals(value)) {
            return "char(32)";
        }
        if (MONEY.getValue().equals(value)) {
            return "float";
        }
        if (USER.getValue().equals(value)) {
            return "char(32)";
        }
        if (PIRMARY.getValue().equals(value)) {
            return "char(32)";
        }
        if (FILE.getValue().equals(value)) {
            return "blob";
        }
        if (IMAGE.getValue().equals(value)) {
            return "blob";
        }
        return "";
    }

    public static String getDBDefValue(Integer value, String val, int lenth) {
        if (Strings.isNullOrEmpty((String)val)) {
            val = "";
        }
        if (STRING.getValue().equals(value)) {
            if (lenth > 1024) {
                return "";
            }
            return " DEFAULT '" + val + "'";
        }
        if (LONG.getValue().equals(value) || DATE.getValue().equals(value) || DOUBLE.getValue().equals(value) || MONEY.getValue().equals(value)) {
            if (val.equals("")) {
                return " DEFAULT 0";
            }
            return " DEFAULT " + val;
        }
        if (AUTOID.getValue().equals(value) || USER.getValue().equals(value) || PIRMARY.getValue().equals(value)) {
            return " DEFAULT '" + val + "'";
        }
        return val;
    }

    public static Map<Integer, String> getList() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(LONG.getValue(), LONG.getName());
        result.put(STRING.getValue(), STRING.getName());
        result.put(DATE.getValue(), DATE.getName());
        result.put(DOUBLE.getValue(), DOUBLE.getName());
        result.put(AUTOID.getValue(), AUTOID.getName());
        result.put(MONEY.getValue(), MONEY.getName());
        result.put(USER.getValue(), USER.getName());
        result.put(PIRMARY.getValue(), PIRMARY.getName());
        result.put(FILE.getValue(), FILE.getName());
        result.put(IMAGE.getValue(), IMAGE.getName());
        return result;
    }
}

