/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.domain;

import com.google.common.base.Strings;
import com.zeto.driver.domain.Column;
import com.zeto.driver.domain.DataType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Table
implements Serializable {
    private String name;
    private String tag;
    private String describe;
    private boolean extend = false;
    private List<Column> columns;
    private Boolean isShowClm = false;
    private String style;
    private String theme;

    public boolean isExtend() {
        return this.extend;
    }

    public void setExtend(boolean extend) {
        this.extend = extend;
    }

    public List<Column> indexColumns() {
        ArrayList<Column> dataColumnList = new ArrayList<Column>();
        for (Column column : this.getColumns()) {
            if (column.getIndex() != 1) continue;
            dataColumnList.add(column);
        }
        return dataColumnList;
    }

    public boolean hasColumn(String name) {
        for (Column column : this.getColumns()) {
            if (!column.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Column column(String name) {
        for (Column column : this.getColumns()) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public boolean isStringColumn(String name) {
        Column column = this.column(name);
        if (column == null) {
            return false;
        }
        return DataType.AUTOID.getValue().equals(column.getType()) || DataType.STRING.getValue().equals(column.getType());
    }

    public Object columnValue(String columnName, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        Column column = this.column(columnName);
        if (column == null) {
            return null;
        }
        if (DataType.LONG.getValue().equals(column.getType()) || DataType.DATE.getValue().equals(column.getType())) {
            return Long.parseLong(value);
        }
        return value;
    }

    public Boolean getShowClm() {
        return this.isShowClm;
    }

    public void setShowClm(Boolean showClm) {
        this.isShowClm = showClm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }
}

