/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.mix;

import com.blade.kit.GsonKit;
import com.google.common.base.Strings;
import com.zeto.ZenData;
import com.zeto.ZenResult;
import com.zeto.ZenUserKit;
import com.zeto.dal.ApiMapper;
import com.zeto.domain.ZenUser;
import com.zeto.driver.mix.domain.MixDO;
import com.zeto.driver.mix.domain.MixItemDO;
import com.zeto.driver.mix.domain.MixParamDO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Executor {
    public abstract ZenResult done(String var1, ZenData var2, ZenUser var3);

    public ZenResult execute(String uri, ZenData data, ZenUser user, String appName) {
        MixDO mixDO = ApiMapper.i().getMixDoByName(appName, uri);
        if (mixDO == null) {
            return ZenResult.fail(uri + "\u63a5\u53e3\u4e0d\u5b58\u5728");
        }
        switch (mixDO.getType()) {
            case "select": {
                return this.select(mixDO, data, user);
            }
            case "get": {
                return this.get(mixDO, data, user);
            }
            case "put": {
                return this.put(mixDO, data, user);
            }
        }
        return ZenResult.fail(uri + "\u63a5\u53e3\u4e0d\u5b58\u5728");
    }

    protected ZenResult select(MixDO mixDO, ZenData data, ZenUser user) {
        ZenResult sonResult;
        ZenResult mainData = this.done(mixDO.getPath(), data, user);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<MixItemDO> sonList = new ArrayList<MixItemDO>();
        for (MixItemDO itemDO : mixDO.getSons()) {
            if ("1".equals(itemDO.getMode()) && !"nick".equals(itemDO.getType())) {
                sonResult = this.done(itemDO.getPath(), data, user);
                result.put(itemDO.getVarName(), sonResult.getData());
                continue;
            }
            sonList.add(itemDO);
        }
        if (mainData.isEmpty()) {
            if (result.size() > 0) {
                result.put("data", null);
                return ZenResult.success().setData(result);
            }
            return mainData;
        }
        List<Map<String, Object>> mapList = mainData.getListWidthMap();
        for (Map<String, Object> row : mapList) {
            for (MixItemDO mixItem : sonList) {
                if ("nick".equals(mixItem.getType())) {
                    this.nick(row, mixItem);
                    continue;
                }
                ZenData params = this.rebuildParam(data, row, mixItem);
                sonResult = this.done(mixItem.getPath(), params, user);
                row.put(mixItem.getVarName(), sonResult.getData());
            }
        }
        if (result.size() > 0) {
            result.put("data", mainData.getData());
            return ZenResult.success().setData(result);
        }
        return mainData;
    }

    protected ZenResult get(MixDO mixDO, ZenData data, ZenUser user) {
        ZenResult mainData = this.done(mixDO.getPath(), data, user);
        if (mainData.isEmpty()) {
            return mainData;
        }
        Map<String, Object> row = mainData.getMap();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (MixItemDO itemDO : mixDO.getSons()) {
            ZenResult sonResult;
            if ("1".equals(itemDO.getMode())) {
                sonResult = this.done(itemDO.getPath(), data, user);
                result.put(itemDO.getVarName(), sonResult.getData());
                continue;
            }
            if ("nick".equals(itemDO.getType())) {
                this.nick(row, itemDO);
                continue;
            }
            ZenData params = this.rebuildParam(data, row, itemDO);
            sonResult = this.done(itemDO.getPath(), params, user);
            row.put(itemDO.getVarName(), sonResult.getData());
        }
        if (result.size() > 0) {
            result.put("data", mainData.getData());
            return ZenResult.success().setData(result);
        }
        return ZenResult.success().setData(row);
    }

    protected ZenResult put(MixDO mixDO, ZenData data, ZenUser user) {
        if ("1".equals(mixDO.getRelate())) {
            MixItemDO mixItemDO = mixDO.getSons()[0];
            String varName = mixItemDO.getVarName();
            String varContent = data.get(varName);
            data.remove(varName);
            if (Strings.isNullOrEmpty((String)varContent)) {
                return ZenResult.fail(varName + "\u53c2\u6570\u627e\u4e0d\u5230");
            }
            if ("1".equals(mixItemDO.getMode())) {
                this.singleFieldMultiPut(mixDO.getPath(), mixItemDO, varContent, data, user);
            } else {
                this.subFormMultiPut(mixDO.getPath(), mixItemDO, varContent, data, user, null);
            }
            return ZenResult.success();
        }
        ZenResult mainResult = this.done(mixDO.getPath(), data, user);
        for (MixItemDO sonItem : mixDO.getSons()) {
            String varName = sonItem.getVarName();
            String varContent = data.get(varName);
            data.remove(varName);
            if (Strings.isNullOrEmpty((String)varContent)) {
                return mainResult;
            }
            if ("1".equals(sonItem.getMode())) {
                this.singleFieldMultiPut(sonItem.getPath(), sonItem, varContent, data, user);
                continue;
            }
            this.subFormMultiPut(sonItem.getPath(), sonItem, varContent, data, user, mainResult);
        }
        return mainResult;
    }

    private void singleFieldMultiPut(String path, MixItemDO mixItemDO, String content, ZenData data, ZenUser user) {
        String[] vals = GsonKit.parse(content, String[].class);
        String behind = mixItemDO.getBehind();
        for (String val : vals) {
            ZenData params = new ZenData(data);
            params.put(behind, val);
            this.done(path, params, user);
        }
    }

    private void subFormMultiPut(String path, MixItemDO mixItemDO, String content, ZenData data, ZenUser user, ZenResult mainResult) {
        List<Map<String, Object>> mapList = GsonKit.parseListMap(content);
        for (Map<String, Object> map : mapList) {
            ZenData params = new ZenData(data);
            params.remove("_id");
            block11: for (MixParamDO paramDO : mixItemDO.getParams()) {
                String key = paramDO.getName();
                switch (paramDO.getFrom()) {
                    case "1": {
                        if (Strings.isNullOrEmpty((String)paramDO.getValue())) {
                            params.put(key, map.get(paramDO.getName()));
                            continue block11;
                        }
                        params.put(key, map.get(paramDO.getValue()));
                        continue block11;
                    }
                    case "2": {
                        if (mainResult == null) continue block11;
                        params.put(key, mainResult.get(paramDO.getValue()));
                        continue block11;
                    }
                    case "3": {
                        params.put(key, paramDO.getValue());
                    }
                }
            }
            ZenResult result = this.done(path, params, user);
            if (result.isSuccess()) continue;
            return;
        }
    }

    private ZenData rebuildParam(ZenData data, Map<String, Object> row, MixItemDO mixItem) {
        ZenData params = new ZenData();
        block10: for (MixParamDO paramDO : mixItem.getParams()) {
            String key = paramDO.getName();
            switch (paramDO.getFrom()) {
                case "1": {
                    if (Strings.isNullOrEmpty((String)paramDO.getValue())) {
                        params.put(key, data.get(paramDO.getName()));
                        continue block10;
                    }
                    params.put(key, data.get(paramDO.getValue()));
                    continue block10;
                }
                case "2": {
                    params.put(key, row.get(paramDO.getValue()));
                    continue block10;
                }
                case "3": {
                    params.put(key, paramDO.getValue());
                }
            }
        }
        return params;
    }

    private void nick(Map<String, Object> row, MixItemDO itemDO) {
        for (MixParamDO paramDO : itemDO.getParams()) {
            Object uidObj = row.get(paramDO.getName());
            if (uidObj == null) continue;
            row.put(paramDO.getValue(), ZenUserKit.nick(uidObj.toString()));
        }
    }
}

