/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.mongodb;

import com.blade.kit.EncryptKit;
import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenSite;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MClient {
    private static final Logger log = LoggerFactory.getLogger(MClient.class);
    private static MongoDatabase database = null;
    private static MongoClient client = null;
    private static final String configName = "mongoDB";
    private static final String ADMIN_DB = "admin";
    private static final String ADMIN_USER = "admin";

    public static void close() {
        if (client != null) {
            client.close();
        }
    }

    public static void init() {
        if (database != null) {
            return;
        }
        String portStr = ZenEnvironment.get("mongoPort");
        int port = 3717;
        if (!Strings.isNullOrEmpty((String)portStr)) {
            port = Integer.parseInt(portStr);
        }
        try {
            String uri = ZenEnvironment.get(configName);
            String dbName = ZenEnvironment.getAppName();
            MongoClientOptions.Builder build = new MongoClientOptions.Builder();
            build.sslEnabled(false);
            build.connectTimeout(4000);
            build.maxWaitTime(3000);
            build.minConnectionsPerHost(5);
            build.maxConnectionLifeTime(0);
            build.heartbeatConnectTimeout(500);
            build.heartbeatFrequency(10000);
            if (ZenEnvironment.isOnline()) {
                build.maxConnectionIdleTime(0);
                build.connectionsPerHost(600);
            } else {
                build.connectionsPerHost(50);
                build.maxConnectionIdleTime(300);
            }
            String password = ZenEnvironment.get("superDB");
            MongoCredential credential = ZenEnvironment.isMulti() ? MongoCredential.createScramSha1Credential((String)"admin", (String)"admin", (char[])password.toCharArray()) : MongoCredential.createScramSha1Credential((String)"admin", (String)"admin", (char[])password.toCharArray());
            String[] uriList = uri.split(",");
            ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
            for (String address : uriList) {
                ServerAddress serverAddress = new ServerAddress(address, port);
                addrs.add(serverAddress);
            }
            client = new MongoClient(addrs, credential, build.build());
            database = client.getDatabase(dbName);
        }
        catch (MongoException e) {
            log.error("", (Throwable)e);
        }
    }

    public static MongoCollection<Document> getCollection(String name) {
        ZenSite zenSite;
        if (ZenEnvironment.isMulti() && (zenSite = WebContext.get().getZenSite()) != null) {
            String dbName = ZenEnvironment.getAppName() + "-" + zenSite.getName();
            return client.getDatabase(dbName).getCollection(name);
        }
        return database.getCollection(name);
    }

    public static void drop(ZenSite site) {
        String dbName = site.getApp() + "-" + site.getName();
        MongoDatabase database = client.getDatabase(dbName);
        database.drop();
    }

    private static String convert(String content) {
        byte[] temp;
        String keyStr = ZenEnvironment.get("ukey");
        byte[] key = new byte[24];
        try {
            temp = keyStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
        if (key.length > temp.length) {
            System.arraycopy(temp, 0, key, 0, temp.length);
        } else {
            System.arraycopy(temp, 0, key, 0, key.length);
        }
        byte[] data = EncryptKit.hexString2Bytes(content);
        byte[] res = EncryptKit.decrypt3DES(data, key);
        return EncryptKit.bytes2HexString(res);
    }
}

