/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.mongodb;

import com.google.common.base.Strings;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.zeto.ZenResult;
import com.zeto.domain.ZenCondition;
import com.zeto.driver.IReadService;
import com.zeto.driver.StorageBase;
import com.zeto.driver.domain.ApiData;
import com.zeto.driver.domain.LeftJoinCondition;
import com.zeto.driver.domain.OrderVO;
import com.zeto.driver.mongodb.MClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MgReadService
extends StorageBase
implements IReadService {
    private static BasicDBObject defaultSort = new BasicDBObject();

    @Override
    public ZenResult get(ApiData apiData) {
        String tableName = apiData.getTableName();
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        Bson condition = apiData.getWhere().MgCondition(tableName);
        if (condition == null) {
            return ZenResult.fail("\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FindIterable findIterable = documentMongoCollection.find(condition).limit(1);
        MongoCursor mongoCursor = findIterable.iterator();
        if (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            mongoCursor.close();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (String key : apiData.outputParams()) {
                data.put(key, document.get((Object)key));
            }
            return ZenResult.success().setData(data);
        }
        return ZenResult.success();
    }

    @Override
    public ZenResult extend(String _id, String tableName) {
        Bson condition;
        List<String> columns = this.getExtendColumns(tableName);
        if (columns == null) {
            return ZenResult.fail();
        }
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        FindIterable findIterable = documentMongoCollection.find(condition = Filters.eq((String)"_id", (Object)_id)).limit(1);
        MongoCursor mongoCursor = findIterable.iterator();
        if (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            mongoCursor.close();
            ZenResult result = ZenResult.success();
            for (String clm : columns) {
                result.put(clm, document.get((Object)clm));
            }
            return result;
        }
        return ZenResult.success();
    }

    @Override
    public ZenResult get(String _id, String tableName) {
        Bson condition;
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        FindIterable findIterable = documentMongoCollection.find(condition = Filters.eq((String)"_id", (Object)_id)).limit(1);
        MongoCursor mongoCursor = findIterable.iterator();
        if (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            mongoCursor.close();
            HashMap<String, Object> data = new HashMap<String, Object>();
            Set keys = document.keySet();
            for (String key : keys) {
                data.put(key, document.get((Object)key));
            }
            return ZenResult.success().setData(data);
        }
        return ZenResult.success();
    }

    @Override
    public long count(ApiData apiData) {
        long count;
        String tableName = apiData.getTableName();
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        Bson condition = apiData.getWhere().MgCondition(tableName);
        if (condition == null) {
            documentMongoCollection.find();
            count = documentMongoCollection.countDocuments();
        } else {
            count = documentMongoCollection.countDocuments(condition);
        }
        return count;
    }

    @Override
    public long count(String tableName) {
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        return documentMongoCollection.countDocuments();
    }

    @Override
    public long count(String tableName, ZenCondition condition) {
        long count;
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        if (condition.isEmpty()) {
            count = documentMongoCollection.countDocuments();
        } else {
            BasicDBObject bson = this.conditionToBson(condition);
            count = documentMongoCollection.countDocuments((Bson)bson);
        }
        return count;
    }

    @Override
    public long sum(String column, String tableName) {
        return this.sum(column, tableName, null);
    }

    @Override
    public long sum(String column, String tableName, ZenCondition condition) {
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        ArrayList<BasicDBObject> sqllist = new ArrayList<BasicDBObject>();
        if (condition != null) {
            BasicDBObject match = this.getMatch(condition);
            sqllist.add(match);
        }
        BasicDBObject sum = new BasicDBObject();
        sum.put((Object)"_id", null);
        sum.put((Object)"total", (Object)new BasicDBObject("$sum", (Object)("$" + column)));
        BasicDBObject group = new BasicDBObject("$group", (Object)sum);
        sqllist.add(group);
        MongoCursor cursor = documentMongoCollection.aggregate(sqllist).iterator();
        if (cursor.hasNext()) {
            Document item = (Document)cursor.next();
            cursor.close();
            return item.getLong((Object)"total");
        }
        cursor.close();
        return 0L;
    }

    @Override
    public ZenResult selectByIds(String tableName, String[] ids) {
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        BasicDBObject condition = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        for (String id : ids) {
            values.add((Object)id);
        }
        condition.put((Object)"_id", (Object)new BasicDBObject("$in", (Object)values));
        List<String> outputs = this.getColumnsWithoutExtend(tableName);
        FindIterable findIterable = documentMongoCollection.find((Bson)condition);
        findIterable.sort((Bson)defaultSort);
        MongoCursor mongoCursor = findIterable.iterator();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        while (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            Map<String, Object> item = this.getRowData(document, outputs);
            data.add(item);
        }
        mongoCursor.close();
        return ZenResult.success().setData(data);
    }

    @Override
    public ZenResult select(String tableName, List<String> outputs, ZenCondition condition) {
        FindIterable findIterable;
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        if (condition.isEmpty()) {
            findIterable = documentMongoCollection.find().skip(condition.getSkip()).limit(condition.getLimit());
        } else {
            BasicDBObject filter = this.conditionToBson(condition);
            findIterable = documentMongoCollection.find((Bson)filter).skip(condition.getSkip()).limit(condition.getLimit());
        }
        Object sort = condition.mgOrder();
        if (sort != null) {
            findIterable.sort((Bson)((BasicDBObject)sort));
        }
        MongoCursor mongoCursor = findIterable.iterator();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (condition.getOutputs() != null) {
            outputs = Arrays.asList(condition.getOutputs());
        }
        if (outputs == null) {
            outputs = this.getColumnsWithoutExtend(tableName);
        }
        while (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            Map<String, Object> item = this.getRowData(document, outputs);
            data.add(item);
        }
        mongoCursor.close();
        return ZenResult.success().setData(data);
    }

    @Override
    public ZenResult select(String tableName, ZenCondition condition) {
        return this.select(tableName, null, condition);
    }

    @Override
    public ZenResult select(String tableName, List<String> outputs, int page, int pageSize) {
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        FindIterable findIterable = documentMongoCollection.find().skip(page * pageSize).limit(pageSize);
        MongoCursor mongoCursor = findIterable.iterator();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (outputs == null) {
            outputs = this.getColumnsWithoutExtend(tableName);
        }
        while (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            Map<String, Object> item = this.getRowData(document, outputs);
            data.add(item);
        }
        mongoCursor.close();
        return ZenResult.success().setData(data);
    }

    @Override
    public ZenResult select(String tableName, int page, int pageSize) {
        return this.select(tableName, null, page, pageSize);
    }

    @Override
    public ZenResult getList(ApiData apiData, int page, int pageSize) {
        if (pageSize > 200) {
            pageSize = 200;
        }
        String tableName = apiData.getTableName();
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        ZenResult result = ZenResult.success();
        Bson condition = apiData.getWhere().MgCondition(tableName);
        FindIterable findIterable = condition == null ? documentMongoCollection.find() : documentMongoCollection.find(condition);
        OrderVO orderVO = apiData.getOrder();
        if (!Strings.isNullOrEmpty((String)orderVO.getName())) {
            BasicDBObject sort = new BasicDBObject();
            sort.put((Object)orderVO.getName(), (Object)orderVO.getType());
            findIterable.sort((Bson)sort);
        }
        if (page > 0) {
            findIterable.skip(page * pageSize);
        }
        findIterable.limit(pageSize);
        MongoCursor mongoCursor = findIterable.iterator();
        ArrayList data = new ArrayList();
        while (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            HashMap<String, Object> item = new HashMap<String, Object>();
            for (String key : apiData.outputParams()) {
                item.put(key, document.get((Object)key));
            }
            data.add(item);
        }
        mongoCursor.close();
        return result.setData(data);
    }

    @Override
    public ZenResult leftJoin(String tableName, LeftJoinCondition condition) {
        MongoCollection<Document> collection = MClient.getCollection(tableName);
        return null;
    }

    private Map<String, Object> getRowData(Document document, List<String> outputs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : outputs) {
            result.put(key, document.get((Object)key));
        }
        return result;
    }

    static {
        defaultSort.put((Object)"_id", (Object)-1);
    }
}

