/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.domain.ZenAction;
import com.zeto.domain.ZenCondition;
import com.zeto.driver.IWriteService;
import com.zeto.driver.StorageBase;
import com.zeto.driver.domain.ApiData;
import com.zeto.driver.domain.InputVO;
import com.zeto.driver.domain.Table;
import com.zeto.driver.mongodb.MClient;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MgWriteService
extends StorageBase
implements IWriteService {
    private static final int extend = 2;

    @Override
    public ZenResult put(ApiData apiData) {
        String primary = apiData.primary();
        if (primary == null) {
            return ZenResult.fail("\u6267\u884c\u5931\u8d25\uff0c\u7f3a\u5c11\u4e3b\u952eID");
        }
        Document document = new Document();
        for (InputVO field : apiData.getParams()) {
            document.append(field.getName(), field.propValue());
        }
        if (!document.isEmpty()) {
            MongoCollection<Document> table = MClient.getCollection(apiData.getTableName());
            table.insertOne((Object)document);
        }
        if (apiData.isSlient()) {
            return ZenResult.success().setAction(ZenAction.SILENT);
        }
        return ZenResult.success("\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public ZenResult patch(String tableName, ZenData data, ZenCondition condition) {
        Document params = new Document();
        Table table = ZenEnvironment.getTable(tableName);
        if (table == null) {
            return ZenResult.fail(tableName + "\u8868\u4e0d\u5b58\u5728");
        }
        for (String key : data.getKeys()) {
            params.append(key, (Object)data.get(key));
        }
        BasicDBObject doc = new BasicDBObject();
        doc.put((Object)"$set", (Object)params);
        MongoCollection<Document> docTable = MClient.getCollection(tableName);
        UpdateResult updateResult = docTable.updateMany((Bson)this.conditionToBson(condition), (Bson)doc);
        return ZenResult.success("\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public ZenResult patch(ApiData apiData) {
        String primary = apiData.primary();
        if (primary == null) {
            return ZenResult.fail("\u6267\u884c\u5931\u8d25\uff0c\u7f3a\u5c11\u4e3b\u952eID");
        }
        String tableName = apiData.getTableName();
        Bson condition = apiData.getWhere().MgCondition(tableName);
        if (condition == null) {
            return ZenResult.fail("\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Document data = new Document();
        for (InputVO field : apiData.getParams()) {
            Object value = field.propValue();
            if (value == null) continue;
            data.append(field.getName(), value);
        }
        if (!data.isEmpty()) {
            BasicDBObject doc = new BasicDBObject();
            doc.put((Object)"$set", (Object)data);
            MongoCollection<Document> table = MClient.getCollection(tableName);
            UpdateResult updateResult = table.updateOne(condition, (Bson)doc);
        }
        if (apiData.isSlient()) {
            return ZenResult.success().setAction(ZenAction.SILENT);
        }
        return ZenResult.success("\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public ZenResult delete(String tableName, ZenCondition condition) {
        MongoCollection<Document> table = MClient.getCollection(tableName);
        DeleteResult deleteResult = table.deleteMany((Bson)this.conditionToBson(condition));
        return ZenResult.success("\u5220\u9664\u6210\u529f").setData(deleteResult.getDeletedCount());
    }

    @Override
    public ZenResult delete(ApiData apiData) {
        String tableName = apiData.getTableName();
        Bson condition = apiData.getWhere().MgCondition(tableName);
        if (condition == null) {
            return ZenResult.fail("\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MongoCollection<Document> table = MClient.getCollection(tableName);
        DeleteResult deleteResult = table.deleteOne(condition);
        if (apiData.isSlient()) {
            return ZenResult.success().setAction(ZenAction.SILENT);
        }
        return ZenResult.success("\u5220\u9664\u6210\u529f").setData(deleteResult.getDeletedCount());
    }
}

