/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.mysql;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.zeto.domain.ZenCondition;
import com.zeto.driver.domain.ConditionOperator;
import java.util.List;

public class MysqlCondition
extends ZenCondition {
    public MysqlCondition(String operator) {
        super(operator);
    }

    @Override
    public ZenCondition like(String key, String keyword) {
        if (Strings.isNullOrEmpty((String)keyword)) {
            return this;
        }
        keyword = "%" + keyword + "%";
        return this.add(key, keyword, ConditionOperator.Like);
    }

    @Override
    public ZenCondition startWith(String key, String keyword) {
        if (Strings.isNullOrEmpty((String)keyword)) {
            return this;
        }
        keyword = "%" + keyword;
        return this.add(key, keyword, ConditionOperator.StartWith);
    }

    @Override
    public ZenCondition endWith(String key, String keyword) {
        if (Strings.isNullOrEmpty((String)keyword)) {
            return this;
        }
        keyword = keyword + "%";
        return this.add(key, keyword, ConditionOperator.EndWith);
    }

    @Override
    public ZenCondition in(String key, List<String> ids) {
        if (ids.isEmpty()) {
            return this;
        }
        String value = "('" + Joiner.on((String)"','").join(ids) + "')";
        return this.add(key, value, ConditionOperator.In);
    }

    @Override
    public ZenCondition notIn(String key, List<String> ids) {
        if (ids.isEmpty()) {
            return this;
        }
        String value = "('" + Joiner.on((String)"','").join(ids) + "')";
        return this.add(key, value, ConditionOperator.NotIn);
    }
}

