/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.mysql;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.dal.DBHelper;
import com.zeto.domain.ZenCondition;
import com.zeto.driver.IReadService;
import com.zeto.driver.StorageBase;
import com.zeto.driver.domain.ApiData;
import com.zeto.driver.domain.Column;
import com.zeto.driver.domain.ConditionVO;
import com.zeto.driver.domain.LeftJoinCondition;
import com.zeto.driver.domain.OrderVO;
import com.zeto.driver.domain.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MysqlReadService
extends StorageBase
implements IReadService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult get(ApiData apiData) {
        List<String> outputs = apiData.outputParams();
        String sql = "SELECT `" + Joiner.on((String)"`,`").join(outputs) + "` FROM `" + apiData.getTableName() + "` WHERE " + apiData.getWhere().SQL() + " LIMIT 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ZenResult result = ZenResult.success();
        try {
            this.setStatmentCondition(apiData, statement);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                for (int i = 0; i < outputs.size(); ++i) {
                    result.put(outputs.get(i), resultSet.getObject(i + 1));
                }
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                ZenResult zenResult = ZenResult.error(e.getMessage());
                dbHelper.close(resultSet);
                return zenResult;
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public ZenResult extend(String _id, String tableName) {
        List<String> clms = this.getExtendColumns(tableName);
        if (clms == null) {
            return ZenResult.fail();
        }
        return this.getById(clms, _id, tableName);
    }

    @Override
    public ZenResult get(String _id, String tableName) {
        Table table = ZenEnvironment.getTable(tableName);
        if (table == null) {
            return ZenResult.fail();
        }
        ArrayList<String> clms = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            clms.add(column.getName());
        }
        return this.getById(clms, _id, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(ApiData apiData) {
        String sql = "SELECT count(`_id`) FROM `" + apiData.getTableName() + "` WHERE " + apiData.getWhere().SQL();
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            this.setStatmentCondition(apiData, statement);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                dbHelper.close(resultSet);
                return l;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return 0L;
    }

    @Override
    public long count(String tableName) {
        String sql = "SELECT count(`_id`) FROM `" + tableName + "`";
        return this.computer(sql);
    }

    @Override
    public long count(String tableName, ZenCondition condition) {
        if (condition.isEmpty()) {
            return this.count(tableName);
        }
        String sql = "SELECT count(`_id`) FROM `" + tableName + "` WHERE " + this.conditionToSQL(condition);
        return this.computer(sql, condition);
    }

    @Override
    public long sum(String column, String tableName) {
        String sql = "SELECT sum(`" + column + "`) FROM `" + tableName + "`";
        return this.computer(sql);
    }

    @Override
    public long sum(String column, String tableName, ZenCondition condition) {
        String sql = "SELECT sum(`" + column + "`) FROM `" + tableName + "` WHERE " + this.conditionToSQL(condition);
        return this.computer(sql, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computer(String sql) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computer(String sql, ZenCondition condition) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            this.setStatmentConditionByTable(condition, statement);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                dbHelper.close(resultSet);
                return l;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult selectByIds(String tableName, String[] ids) {
        List<String> outputs = this.getColumnsWithoutExtend(tableName);
        String sql = "SELECT `" + Joiner.on((String)"`,`").join(outputs) + "` FROM `" + tableName + "` WHERE `_id` in ('" + Joiner.on((String)"','").join((Object[])ids) + "') LIMIT 100";
        ZenResult result = ZenResult.success();
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            ZenResult zenResult = result.setData(this.selectResult(outputs, resultSet));
            return zenResult;
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close(resultSet);
        }
    }

    @Override
    public ZenResult select(String tableName, ZenCondition condition) {
        return this.select(tableName, null, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult select(String tableName, List<String> outputs, ZenCondition condition) {
        if (condition.getOutputs() != null) {
            outputs = Arrays.asList(condition.getOutputs());
        }
        if (outputs == null) {
            outputs = this.getColumnsWithoutExtend(tableName);
        }
        String sql = "SELECT `" + Joiner.on((String)"`,`").join(outputs) + "` FROM `" + tableName + "`";
        String where = this.conditionOnSQL(condition);
        String order = condition.sqlOrder();
        if (!Strings.isNullOrEmpty((String)where)) {
            sql = sql + " WHERE " + this.conditionToSQL(condition);
        }
        if (order != null) {
            sql = sql + order;
        }
        sql = sql + " LIMIT " + condition.getSkip() + "," + condition.getLimit();
        ZenResult result = ZenResult.success();
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            this.setStatmentConditionByTable(condition, statement);
            resultSet = statement.executeQuery();
            ZenResult zenResult = result.setData(this.selectResult(outputs, resultSet));
            dbHelper.close(resultSet);
            return zenResult;
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                ZenResult zenResult = ZenResult.error(e.getMessage());
                dbHelper.close(resultSet);
                return zenResult;
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
    }

    @Override
    public ZenResult select(String tableName, int page, int pageSize) {
        return this.select(tableName, null, page, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult select(String tableName, List<String> outputs, int page, int pageSize) {
        if (outputs == null) {
            outputs = this.getColumnsWithoutExtend(tableName);
        }
        int start = page * pageSize;
        String sql = "SELECT `" + Joiner.on((String)"`,`").join(outputs) + "` FROM `" + tableName + "` LIMIT " + start + "," + pageSize;
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            ZenResult zenResult = ZenResult.success().setData(this.selectResult(outputs, resultSet));
            return zenResult;
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult getList(ApiData apiData, int page, int pageSize) {
        OrderVO orderVO;
        if (pageSize > 200) {
            pageSize = 200;
        }
        int start = page * pageSize;
        List<String> outputs = apiData.outputParams();
        String tableName = apiData.getTableName();
        String conditionStr = apiData.getWhere().SQL();
        String sql = "SELECT `" + Joiner.on((String)"`,`").join(outputs) + "` FROM `" + tableName + "`";
        if (conditionStr != null) {
            sql = sql + " WHERE " + apiData.getWhere().SQL();
        }
        if ((orderVO = apiData.getOrder()) != null && !Strings.isNullOrEmpty((String)orderVO.getName())) {
            if (orderVO.getType() == -1) {
                sql = sql + " ORDER By `" + orderVO.getName() + "` DESC";
            }
            if (orderVO.getType() == 1) {
                sql = sql + " ORDER By `" + orderVO.getName() + "` ASC";
            }
        }
        sql = sql + " LIMIT " + start + "," + pageSize;
        ZenResult result = ZenResult.success();
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            if (conditionStr != null) {
                this.setStatmentCondition(apiData, statement);
            }
            resultSet = statement.executeQuery();
            ArrayList data = new ArrayList();
            while (resultSet.next()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                for (int i = 0; i < outputs.size(); ++i) {
                    item.put(outputs.get(i), resultSet.getObject(i + 1));
                }
                data.add(item);
            }
            ZenResult zenResult = result.setData(data);
            return zenResult;
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close(resultSet);
        }
    }

    @Override
    public ZenResult leftJoin(String tableName, LeftJoinCondition condition) {
        ZenCondition leftCondition = condition.getLeftCondition();
        ZenCondition rigthCondition = condition.getRightCondition();
        List<String> outputs = null;
        if (leftCondition.getOutputs() != null) {
            outputs = Arrays.asList(leftCondition.getOutputs());
        }
        if (outputs == null) {
            outputs = this.getColumnsWithoutExtend(tableName);
        }
        String rightTableName = rigthCondition.getTable().getName();
        String countSql = "SELECT count(*) FROM `" + tableName + " LEFT JOIN `" + rightTableName + "` on " + tableName + "." + condition.getLeftField() + "=" + rightTableName + "." + condition.getRightField() + " `";
        String left = this.conditionOnSQL(leftCondition);
        String right = this.conditionOnSQL(rigthCondition);
        if (left != null) {
            countSql = countSql + " AND " + left;
        }
        if (right != null) {
            countSql = countSql + " AND " + right;
        }
        String sql = countSql.replace("count(*)", "`" + Joiner.on((String)"`,`").join(outputs) + "`," + rightTableName + "._id as _source");
        String order = leftCondition.sqlOrder(tableName);
        if (order != null) {
            sql = sql + order;
        }
        sql = sql + " LIMIT " + leftCondition.getSkip() + "," + leftCondition.getLimit();
        List<ConditionVO> conditionVOList = leftCondition.getConditions();
        for (int i = 0; i < conditionVOList.size(); ++i) {
            ConditionVO conditionVO = conditionVOList.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZenResult getById(List<String> clms, String _id, String tableName) {
        String sql = "SELECT `" + Joiner.on((String)"`,`").join(clms) + "` FROM `" + tableName + "` WHERE `_id`=? LIMIT 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        ZenResult result = ZenResult.success();
        try {
            statement.setString(1, _id);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                for (int i = 0; i < clms.size(); ++i) {
                    result.put(clms.get(i), resultSet.getObject(i + 1));
                }
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                ZenResult zenResult = ZenResult.error(e.getMessage());
                dbHelper.close(resultSet);
                return zenResult;
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return result;
    }

    private List<Object> selectResult(List<String> columns, ResultSet resultSet) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (resultSet.next()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            for (int i = 0; i < columns.size(); ++i) {
                item.put(columns.get(i), resultSet.getObject(i + 1));
            }
            result.add(item);
        }
        return result;
    }
}

