/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.driver.mysql;

import com.google.common.base.Joiner;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.dal.DBHelper;
import com.zeto.domain.ZenAction;
import com.zeto.domain.ZenCondition;
import com.zeto.driver.IWriteService;
import com.zeto.driver.StorageBase;
import com.zeto.driver.domain.ApiData;
import com.zeto.driver.domain.Column;
import com.zeto.driver.domain.ConditionExprVO;
import com.zeto.driver.domain.ConditionVO;
import com.zeto.driver.domain.InputVO;
import com.zeto.driver.domain.Table;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MysqlWriteService
extends StorageBase
implements IWriteService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult put(ApiData apiData) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> placeholder = new ArrayList<String>();
        List<InputVO> inputVOList = apiData.getParams();
        String tableName = apiData.getTableName();
        Table table = apiData.getTable();
        for (InputVO field : inputVOList) {
            placeholder.add("?");
            fields.add(field.getName());
        }
        String sql = "INSERT INTO `" + tableName + "`(`" + Joiner.on((String)"`,`").join(fields) + "`)VALUES(" + Joiner.on((char)',').join(placeholder) + ")";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            for (int i = 0; i < inputVOList.size(); ++i) {
                InputVO inputVO = inputVOList.get(i);
                this.setStatmentParam(i + 1, inputVO.getValue(), table.isStringColumn(inputVO.getName()), statement);
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close();
        }
        if (apiData.isSlient()) {
            return ZenResult.success().setAction(ZenAction.SILENT);
        }
        return ZenResult.success("\u4fdd\u5b58\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult patch(String tableName, ZenData data, ZenCondition condition) {
        ArrayList<String> fields = new ArrayList<String>();
        Table table = ZenEnvironment.getTable(tableName);
        if (table == null) {
            return ZenResult.fail(tableName + "\u8868\u4e0d\u5b58\u5728");
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String key : data.getKeys()) {
            Column column = table.column(key);
            if (column == null) continue;
            column.setValue(data.get(key));
            columns.add(column);
        }
        for (Column field : columns) {
            if (field.getType() == null) continue;
            fields.add("`" + field.getName() + "`=?");
        }
        String sql = "UPDATE `" + tableName + "` SET " + Joiner.on((char)',').join(fields) + " WHERE " + this.conditionToSQL(condition);
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            int j;
            for (j = 0; j < columns.size(); ++j) {
                int idx = j + 1;
                Column clm = (Column)columns.get(j);
                this.setStatmentParam(idx, clm.getValue(), table.isStringColumn(clm.getName()), statement);
            }
            List<ConditionVO> conditionVOList = condition.getConditions();
            for (int i = 0; i < conditionVOList.size(); ++i) {
                ConditionVO conditionVO = conditionVOList.get(i);
                int idx = i + j + 1;
                this.setStatmentParam(idx, conditionVO.getValue(), conditionVO.isString(), statement);
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close();
        }
        return ZenResult.success("\u4fdd\u5b58\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult patch(ApiData apiData) {
        ArrayList<String> fields = new ArrayList<String>();
        List<InputVO> inputVOList = apiData.getParams();
        for (InputVO field : inputVOList) {
            fields.add("`" + field.getName() + "`=?");
        }
        String tableName = apiData.getTableName();
        Table table = ZenEnvironment.getTable(tableName);
        String sql = "UPDATE `" + tableName + "` SET " + Joiner.on((char)',').join(fields) + " WHERE " + apiData.getWhere().SQL();
        List<ConditionExprVO> whereExprs = apiData.getWhere().getValues();
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            int idx;
            int j;
            for (j = 0; j < inputVOList.size(); ++j) {
                idx = j + 1;
                InputVO inputVO = inputVOList.get(j);
                this.setStatmentParam(idx, inputVO.getValue(), table.isStringColumn(inputVO.getName()), statement);
            }
            for (int i = 0; i < whereExprs.size(); ++i) {
                ConditionExprVO exprVO = whereExprs.get(i);
                idx = i + j + 1;
                this.setStatmentParam(idx, exprVO.getValue(), table.isStringColumn(exprVO.getColumn()), statement);
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close();
        }
        if (apiData.isSlient()) {
            return ZenResult.success().setAction(ZenAction.SILENT);
        }
        return ZenResult.success("\u4fdd\u5b58\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult delete(String tableName, ZenCondition condition) {
        ZenResult result = ZenResult.success();
        String sql = "DELETE FROM `" + tableName + "` WHERE " + this.conditionToSQL(condition);
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            this.setStatmentConditionByTable(condition, statement);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZenResult delete(ApiData apiData) {
        String sql = "DELETE FROM `" + apiData.getTableName() + "` WHERE " + apiData.getWhere().SQL();
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            this.setStatmentCondition(apiData, statement);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
            ZenResult zenResult = ZenResult.error(e.getMessage());
            return zenResult;
        }
        finally {
            dbHelper.close();
        }
        if (apiData.isSlient()) {
            return ZenResult.success().setAction(ZenAction.SILENT);
        }
        return ZenResult.success("\u5220\u9664\u6210\u529f");
    }
}

