/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.eventbus.listener;

import com.google.common.eventbus.Subscribe;
import com.zeto.ZenEnvironment;
import com.zeto.ZenUserKit;
import com.zeto.driver.domain.Table;
import com.zeto.eventbus.domain.DbEventModel;
import com.zeto.eventbus.listener.dbRsync.MysqlRsync;
import com.zeto.eventbus.listener.dbRsync.SqliteRsync;
import java.util.List;

public class DbListener {
    @Subscribe
    public void execute(DbEventModel dbEvent) {
        Object rsync;
        List<Table> tables = ZenEnvironment.getTables();
        if (tables == null) {
            return;
        }
        if (ZenEnvironment.isMysqlPrivate()) {
            rsync = new MysqlRsync();
            ((MysqlRsync)rsync).execute(tables);
        }
        if (ZenEnvironment.isSqlitePrivate()) {
            rsync = new SqliteRsync();
            ((SqliteRsync)rsync).execute(tables);
        }
        ZenUserKit.resetRoot();
    }
}

