/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.eventbus.listener;

import com.blade.kit.HttpKit;
import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.domain.ZenApp;
import com.zeto.eventbus.EventBiz;
import com.zeto.eventbus.domain.PidModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeListener {
    private static final Logger log = LoggerFactory.getLogger(UpgradeListener.class);

    @Subscribe
    public void upgrade(ZenApp app) {
        ZenData params = ZenData.create("app", ZenEnvironment.getAppName());
        params.put("version", ZenEnvironment.get("version"));
        params.put("domain", ZenEnvironment.get("domain"));
        String content = HttpKit.post("https://www.kooteam.com/home/download.do", params);
        if (Strings.isNullOrEmpty((String)content)) {
            return;
        }
        ZenResult result = ZenResult.parse(content);
        if (!result.isSuccess()) {
            return;
        }
        this.updateVersion(result.getData().toString());
        try {
            String command = "nohup " + ZenEnvironment.getPath() + "/upgrade.sh >/del/nul 2>&1 &";
            Runtime.getRuntime().exec(command);
            EventBiz.upgradeEnd();
        }
        catch (IOException e) {
            log.error("upgrade error", (Throwable)e);
        }
    }

    @Subscribe
    public void createPid(PidModel pidModel) {
        Integer pid = pidModel.getPid();
        if (pid == -1) {
            return;
        }
        String path = ZenEnvironment.getPath() + "/" + ZenEnvironment.getAppName() + ".pid";
        File file = new File(path);
        try {
            if (!file.exists()) {
                Files.touch((File)file);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));
            writer.write(pid.toString());
            writer.close();
        }
        catch (IOException e) {
            log.error("pid created error", (Throwable)e);
        }
    }

    private void updateVersion(String version) {
        String profilepath = ZenEnvironment.getPath() + "/app.properties";
        try {
            File propFile = new File(profilepath);
            if (!propFile.exists()) {
                return;
            }
            Properties props = new Properties();
            props.load(new FileInputStream(profilepath));
            props.setProperty("version", version);
            FileOutputStream fos = new FileOutputStream(profilepath);
            props.store(fos, "");
            ((OutputStream)fos).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

