/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.eventbus.listener.dbRsync;

import com.google.common.base.Joiner;
import com.zeto.dal.DBHelper;
import com.zeto.driver.domain.Column;
import com.zeto.driver.domain.DataType;
import com.zeto.driver.domain.Table;
import com.zeto.eventbus.domain.DbColumn;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SqliteRsync {
    public void execute(List<Table> tables) {
        List<String> tableNames = this.getTables();
        for (Table table : tables) {
            boolean isCreate = true;
            String current = table.getName();
            for (String tableName : tableNames) {
                if (!current.equals(tableName) && !current.toLowerCase().equals(tableName)) continue;
                isCreate = false;
                break;
            }
            if (isCreate) {
                this.createTable(table);
                continue;
            }
            this.changeTable(table);
        }
    }

    private void createTable(Table table) {
        ArrayList<String> columns = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            columns.add("`" + column.getName() + "` " + this.getType(column) + column.dbDefValue());
        }
        columns.add("PRIMARY KEY (_id)");
        String sql = "CREATE TABLE `" + table.getName() + "`(" + Joiner.on((char)',').join(columns) + ");";
        this.dbExecute(sql);
    }

    private void changeTable(Table table) {
        List<DbColumn> columns = this.getTableColumns(table.getName());
        for (Column column : table.getColumns()) {
            int isNew = 0;
            for (DbColumn dbColumn : columns) {
                if (!dbColumn.getName().equals(column.getName())) continue;
                if (dbColumn.getType().equals(this.getType(column))) {
                    isNew = 2;
                    break;
                }
                isNew = 1;
                break;
            }
            if (isNew == 2 || isNew != 0) continue;
            String sql = "ALTER TABLE `" + table.getName() + "` ADD `" + column.getName() + "` " + this.getType(column) + column.dbDefValue();
            this.dbExecute(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbColumn> getTableColumns(String tableName) {
        ArrayList<DbColumn> columns = new ArrayList<DbColumn>();
        String sql = "PRAGMA  table_info(`" + tableName + "`)";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                DbColumn column = new DbColumn();
                column.setName(resultSet.getString(2).trim());
                column.setType(resultSet.getString(3).trim());
                column.setDefValue(resultSet.getString(5));
                columns.add(column);
            }
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return columns;
    }

    private String getType(Column column) {
        return DataType.getSqliteType(column.getType(), column.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbExecute(String sql) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.execute();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTables() {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select name from sqlite_master where type='table' order by name;";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                result.add(resultSet.getString(1).trim());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return result;
    }
}

