/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.executor;

import com.blade.kit.PatternKit;
import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.zeto.ZenCookie;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenFiles;
import com.zeto.ZenResult;
import com.zeto.ZenSession;
import com.zeto.annotation.AccessRole;
import com.zeto.annotation.MethodType;
import com.zeto.controller.Zeto;
import com.zeto.domain.MethodMap;
import com.zeto.domain.ZenAction;
import com.zeto.domain.ZenMethod;
import com.zeto.domain.ZenRole;
import com.zeto.domain.ZenUser;
import com.zeto.kit.TagKit;
import com.zeto.util.RequestUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoExecutor {
    private static final Logger log = LoggerFactory.getLogger(DoExecutor.class);
    private static Map<String, MethodMap> routeMap = new HashMap<String, MethodMap>();
    private static final String sessionName = "_session";
    private static final Zeto zeto = new Zeto();

    private static void addMethods(String controllerName, Object bean) {
        Method[] methods;
        MethodMap methodMap = new MethodMap(bean);
        for (Method method : methods = bean.getClass().getMethods()) {
            String returnType = method.getReturnType().getSimpleName();
            if (!returnType.equals("ZenResult")) continue;
            String methodName = method.getName().toLowerCase();
            methodMap.put(methodName, method);
        }
        routeMap.put(controllerName, methodMap);
    }

    public static void init(String packagePath, List<Object> beans) {
        for (Object bean : beans) {
            String controllerName = bean.getClass().getName();
            if (!controllerName.contains(packagePath)) continue;
            if ((controllerName = controllerName.substring(packagePath.length() + 1).toLowerCase()).contains(".")) {
                controllerName = controllerName.substring(controllerName.lastIndexOf(".") + 1);
            }
            DoExecutor.addMethods(controllerName, bean);
        }
        DoExecutor.addMethods("zeto", zeto);
    }

    public ZenResult execute(Request request, Response response, String uri, ZenData data, ZenUser user) {
        return this.execute(request, response, uri, data, user, true);
    }

    public ZenResult execute(Request request, Response response, String uri, ZenData data, ZenUser user, boolean checkMethod) {
        long roles;
        Object target;
        AccessRole accessRole;
        String[] uris = uri.split("/");
        if (uri.length() < 2) {
            return this.Result404();
        }
        String controllerName = uris[0].toLowerCase();
        String methodName = uris[1].toLowerCase();
        MethodMap methodMap = routeMap.get(controllerName);
        if (methodMap == null) {
            return this.Result404();
        }
        Method method = methodMap.get(methodName);
        if (method == null) {
            return this.Result404();
        }
        if (checkMethod) {
            MethodType methodType = method.getAnnotation(MethodType.class);
            String httpMethod = request.method();
            if (methodType == null) {
                if (!httpMethod.equals(ZenMethod.POST.getValue())) {
                    return ZenResult.fail("http\u8bf7\u6c42\u7c7b\u578b\u9519\u8bef\uff0c\u9ed8\u8ba4\u7c7b\u578b\u4e3a:POST");
                }
            } else {
                String methodTypeStr = methodType.value().getValue();
                if (!methodTypeStr.equals(ZenMethod.ALL.getValue()) && !httpMethod.equals(methodTypeStr)) {
                    return ZenResult.fail("http\u8bf7\u6c42\u7c7b\u578b\u9519\u8bef\uff0c\u8981\u6c42\u7c7b\u578b\u4e3a:" + methodTypeStr);
                }
            }
        }
        if ((accessRole = (target = methodMap.getBean()).getClass().getAnnotation(AccessRole.class)) == null) {
            return ZenResult.noPermision();
        }
        int roleValue = accessRole.value().value();
        if (roleValue > 0) {
            if (user == null) {
                return ZenResult.noLogin();
            }
            if (roleValue == 1 && ZenEnvironment.isOnline()) {
                return ZenResult.fail("\u7ebf\u4e0a\u73af\u5883\u4e0d\u80fd\u8fd0\u884c");
            }
            if (roleValue != 2 && !user.hasTag(accessRole.value())) {
                return ZenResult.noPermision();
            }
        }
        if ((roles = accessRole.roles()) > 0L) {
            if (user == null) {
                return ZenResult.noLogin();
            }
            int[] roleRangle = ZenRole.rangle();
            boolean hasAuth = false;
            for (int i = roleRangle[0]; i <= roleRangle[1]; ++i) {
                if (!TagKit.contain(roles, i) || !TagKit.contain(user.getTag(), i)) continue;
                hasAuth = true;
                break;
            }
            if (!hasAuth) {
                return ZenResult.noPermision();
            }
        }
        Parameter[] parameters = method.getParameters();
        try {
            Object returnParam;
            if (parameters.length > 0) {
                Object[] args = this.getArgs(parameters, request, response, user, data, uri);
                returnParam = ReflectKit.invokeMethod(target, method, args);
            } else {
                returnParam = ReflectKit.invokeMethod(target, method, new Object[0]);
            }
            return (ZenResult)returnParam;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return ZenResult.error(e);
        }
    }

    private ZenResult Result404() {
        return ZenResult.fail("404 error").setAction(ZenAction.FATAL);
    }

    private Object[] getArgs(Parameter[] parameters, Request request, Response response, ZenUser user, ZenData data, String path) {
        Object[] args = new Object[parameters.length];
        Integer i = 0;
        while (i < parameters.length) {
            String argTypeName = parameters[i].getType().getSimpleName();
            if (argTypeName.equals("ZenData")) {
                args[i.intValue()] = data;
            } else if (argTypeName.equals("ZenUser")) {
                if (user == null) {
                    user = RequestUtil.getUser(request);
                }
                args[i.intValue()] = user;
            } else if (argTypeName.equals("ZenCookie")) {
                args[i.intValue()] = new ZenCookie(request.cookies());
            } else {
                if (argTypeName.equals("ZenFiles")) {
                    args[i.intValue()] = new ZenFiles(request.fileItems());
                }
                if (argTypeName.equals("Request")) {
                    args[i.intValue()] = request;
                }
                if (argTypeName.equals("Response")) {
                    args[i.intValue()] = response;
                }
                if (argTypeName.equals("String")) {
                    args[i.intValue()] = path;
                }
                if (argTypeName.equals("ZenSession")) {
                    if (user == null) {
                        String sesionId = request.cookie(sessionName);
                        if (!PatternKit.isObjectId(sesionId)) {
                            sesionId = StringKit.objectId();
                            response.cookie(sessionName, sesionId);
                        }
                        args[i.intValue()] = new ZenSession(sesionId);
                    } else {
                        args[i.intValue()] = new ZenSession(user.getUid());
                    }
                }
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return args;
    }
}

