/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.executor;

import com.blade.mvc.WebContext;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.source.ISourceFactory;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenSite;
import com.zeto.executor.enjoy.ApiDirective;
import com.zeto.executor.enjoy.CdnDirective;
import com.zeto.executor.enjoy.ConfigDirective;
import com.zeto.executor.enjoy.DateDirective;
import com.zeto.executor.enjoy.LibDirective;
import com.zeto.executor.enjoy.SculBlockDirective;
import com.zeto.executor.enjoy.ShortDateDirective;
import com.zeto.executor.enjoy.SkinBlockDirective;
import com.zeto.executor.enjoy.TemplateBlockDirective;
import com.zeto.executor.enjoy.source.SculSource;
import com.zeto.executor.enjoy.source.SkinSource;
import com.zeto.executor.enjoy.source.TemplateSource;
import java.util.HashMap;
import java.util.Map;

public class EnjoyExecutor {
    private static Map<String, Engine> engines = new HashMap<String, Engine>();
    private static final String ENV_KEY = "env";

    public static String scul(String path) {
        return EnjoyExecutor.render(path, true);
    }

    public static String render(String path) {
        return EnjoyExecutor.render(path, false);
    }

    public static String renderTemplate(String path) {
        Map<String, Object> params = EnjoyExecutor.getParams(path);
        String appName = ZenEnvironment.getAppName();
        Engine engine = EnjoyExecutor.get(appName, false, false);
        Template template = engine.getTemplate(path);
        if (template == null) {
            return null;
        }
        return template.renderToString(params);
    }

    public static String render(String path, boolean isScul) {
        boolean isSkinMode;
        String appName;
        Map<String, Object> params = EnjoyExecutor.getParams(path);
        ZenSite site = WebContext.get().getZenSite();
        if (site == null) {
            appName = ZenEnvironment.getAppName();
            isSkinMode = false;
        } else {
            appName = site.getId();
            isSkinMode = true;
        }
        return EnjoyExecutor.get(appName, isScul, isSkinMode).getTemplate(path).renderToString(params);
    }

    private static Map<String, Object> getParams(String path) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("path", path);
        params.put("mode", ZenEnvironment.getMode());
        params.put(ENV_KEY, ZenEnvironment.get(ENV_KEY));
        params.put("site", WebContext.get().getZenSite());
        return params;
    }

    public static void removeCache(String cacheKey) {
        Engine engine;
        if (ZenEnvironment.isDev()) {
            return;
        }
        String name = ZenEnvironment.getAppName();
        ZenSite site = WebContext.get().getZenSite();
        if (site != null && !cacheKey.contains(".html")) {
            name = site.getId();
        }
        if ((engine = engines.get(name)) == null) {
            return;
        }
        engine.removeTemplateCache("/" + cacheKey);
    }

    private static Engine get(String name, boolean isScul, boolean isSkinMode) {
        if (isScul) {
            name = name + "scul";
        }
        if (engines.containsKey(name)) {
            return engines.get(name);
        }
        Engine templateEngine = Engine.create((String)name);
        if (!ZenEnvironment.isOnline()) {
            templateEngine.setDevMode(true);
        }
        templateEngine.removeDirective("date");
        templateEngine.removeDirective("define");
        templateEngine.addDirective("date", DateDirective.class);
        templateEngine.addDirective("shortdate", ShortDateDirective.class);
        templateEngine.addDirective("datasource", ApiDirective.class);
        templateEngine.addDirective("cdn", CdnDirective.class);
        templateEngine.addDirective("lib", LibDirective.class);
        templateEngine.addDirective("config", ConfigDirective.class);
        if (isScul) {
            templateEngine.addDirective("block", SculBlockDirective.class);
            templateEngine.setSourceFactory((ISourceFactory)new SculSource());
        } else {
            templateEngine.setBaseTemplatePath(name);
            if (isSkinMode) {
                templateEngine.addDirective("block", SkinBlockDirective.class);
                templateEngine.setSourceFactory((ISourceFactory)new SkinSource());
            } else {
                templateEngine.addDirective("block", TemplateBlockDirective.class);
                templateEngine.setSourceFactory((ISourceFactory)new TemplateSource());
            }
        }
        templateEngine.setEncoding("UTF-8");
        engines.put(name, templateEngine);
        return templateEngine;
    }
}

