/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.executor;

import com.blade.kit.GsonKit;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.zeto.Zen;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.dal.SiteMapper;
import com.zeto.domain.ZenAction;
import com.zeto.domain.ZenMethod;
import com.zeto.domain.ZenSite;
import com.zeto.domain.ZenUser;
import com.zeto.driver.ZenStorageEngine;
import com.zeto.executor.DoExecutor;
import com.zeto.executor.StaticExecutor;
import com.zeto.executor.domain.MergeParamDO;
import com.zeto.util.RequestUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoke {
    private static final Logger log = LoggerFactory.getLogger(Invoke.class);
    private ZenStorageEngine zenStorageEngine = Zen.getStorageEngine();
    private DoExecutor doAction = Zen.getDoAction();
    private static final StaticExecutor htmlRender = new StaticExecutor();
    private static final String blank = "/";
    private static final String hostVar = "Host";

    public Response handle(WebContext webContext) {
        Request request = webContext.getRequest();
        Response response = webContext.getResponse();
        String uri = request.uri();
        try {
            String ext;
            if (uri.equals(blank)) {
                uri = ZenEnvironment.getHomeURI();
            }
            if ((ext = StringKit.fileExt(uri)) == null) {
                response.status(404);
                return response;
            }
            this.prepareContext(webContext);
            if ("json".equals(ext)) {
                uri = uri.substring(1, uri.length() - 5);
                ZenUser user = RequestUtil.getUser(request);
                ZenData data = request.parameters();
                ZenResult result = this.zenStorageEngine.execute(uri, data, user);
                response.text(result.toJSON());
                return response;
            }
            if ("do".equals(ext)) {
                if (uri.startsWith("/_")) {
                    return this.mergeResonse(request, response);
                }
                return this.executeDo(uri, request, response);
            }
            return htmlRender.output(uri, ext, response);
        }
        catch (Exception e) {
            log.error(uri, (Throwable)e);
            return response;
        }
    }

    private Response mergeResonse(Request request, Response response) {
        String content = request.parameters().get("_");
        List<MergeParamDO> paramDOList = GsonKit.parseList(content, MergeParamDO.class);
        ZenUser user = RequestUtil.getUser(request);
        ZenResult result = ZenResult.success();
        for (MergeParamDO paramDO : paramDOList) {
            ZenResult current;
            String uri = paramDO.getUrl();
            if (paramDO.getUrl().endsWith("do")) {
                uri = uri.substring(1, uri.length() - 3);
                current = this.doAction.execute(request, response, uri, paramDO.getParams(), user);
            } else {
                uri = uri.substring(1, uri.length() - 5);
                current = this.zenStorageEngine.execute(uri, paramDO.getParams(), user);
            }
            if (current.getAction().equals(ZenAction.GOLOGIN.getValue())) {
                response.text(current.toJSON());
                return response;
            }
            if (current.getAction().equals(ZenAction.REDIRECT.getValue())) {
                response.redirect(current.getMessage());
                return response;
            }
            if (current.getAction().equals(ZenAction.FATAL.getValue())) {
                response.text(current.toJSON());
                return response;
            }
            if (current.getAction().equals(ZenAction.GOTO.getValue())) {
                String tmphHTML = RequestUtil.jsGOTO(current);
                response.html(tmphHTML);
                return response;
            }
            result.put(paramDO.getName(), current.getData());
        }
        response.text(result.toJSON());
        return response;
    }

    private Response executeDo(String uri, Request request, Response response) {
        uri = uri.substring(1, uri.length() - 3);
        ZenUser user = RequestUtil.getUser(request);
        ZenData data = request.parameters();
        ZenResult result = this.doAction.execute(request, response, uri, data, user);
        if (result == null) {
            return response;
        }
        if (result.getCookies() != null) {
            for (Cookie cookie : result.getCookies()) {
                response.cookie(cookie);
            }
        }
        if (result.getAction().equals(ZenAction.REDIRECT.getValue())) {
            response.redirect(result.getMessage());
            return response;
        }
        if (result.getAction().equals(ZenAction.GOTO.getValue())) {
            String tmphHTML = RequestUtil.jsGOTO(result);
            response.html(tmphHTML);
            return response;
        }
        String callback = request.parameters().get("callback");
        if (callback != null && request.method().equals(ZenMethod.GET.getValue())) {
            response.text(String.format("%s(%s)", callback, result.toJSON()));
        } else {
            response.text(result.toJSON());
        }
        return response;
    }

    private void prepareContext(WebContext webContext) {
        String privateDomain;
        if (!ZenEnvironment.isMulti()) {
            return;
        }
        ZenSite zenSite = null;
        String host = webContext.getRequest().header(hostVar);
        if (!host.contains(privateDomain = ZenEnvironment.get("privateDomain"))) {
            zenSite = SiteMapper.i().getByDomain(host);
        }
        String siteName = host.substring(0, host.indexOf("."));
        if (zenSite == null) {
            zenSite = SiteMapper.i().getByName(siteName);
        }
        webContext.setZenSite(zenSite);
        WebContext.set(webContext);
    }
}

