/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.executor.enjoy;

import com.blade.mvc.WebContext;
import com.blade.mvc.http.Request;
import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import com.zeto.Zen;
import com.zeto.ZenData;
import com.zeto.ZenResult;
import com.zeto.domain.ZenUser;
import com.zeto.driver.ZenStorageEngine;
import com.zeto.executor.DoExecutor;
import com.zeto.util.RequestUtil;

public class ApiDirective
extends Directive {
    private String varName;
    private String uri;
    private ZenStorageEngine zenStorageEngine = Zen.getStorageEngine();
    private DoExecutor doAction = Zen.getDoAction();
    private static final String doActionExt = ".do";

    public void setExprList(ExprList exprList) {
        if (exprList.length() != 2) {
            throw new ParseException("The parameter of #define directive can not be blank", this.location);
        }
        this.varName = exprList.getFirstExpr().toString();
        this.uri = exprList.getLastExpr().toString();
    }

    public void exec(Env env, Scope scope, Writer writer) {
        ZenResult result;
        String url;
        WebContext context = WebContext.get();
        Request request = context.getRequest();
        ZenUser user = RequestUtil.getUser(request);
        ZenData data = request.parameters();
        int idx = this.uri.indexOf("?");
        if (idx > 0) {
            String[] params;
            url = this.uri.substring(0, idx);
            String queryStr = this.uri.substring(idx + 1);
            for (String param : params = queryStr.split("&")) {
                String[] kv = param.split("=");
                if (kv.length != 2) continue;
                data.put(kv[0], kv[1]);
            }
        } else {
            url = this.uri;
        }
        if (url.contains(doActionExt)) {
            url = url.substring(0, url.length() - 3);
            result = this.doAction.execute(request, context.getResponse(), url, data, user, false);
        } else {
            result = this.zenStorageEngine.execute(url, data, user);
        }
        scope.getData().put(this.varName, result.getData());
    }
}

