/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.executor.enjoy;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import com.zeto.ZenEnvironment;

public class CdnDirective
extends Directive {
    private static final String onlineDomain = "//a.yimiyisu.com";
    private static final String dailyCDN = "//cdn-daily.yimiyisu.com";
    private static final String devCDN = "//cdn-dev.yimiyisu.com";
    private static final String preCDN = "//cdn.pre.zeto.me";
    private String val = null;

    public String getDomain() {
        return CdnDirective.getCDN();
    }

    public static String getCDN() {
        if (ZenEnvironment.isOnline()) {
            return onlineDomain;
        }
        if (ZenEnvironment.isDev()) {
            return devCDN;
        }
        if (ZenEnvironment.isDaily()) {
            return dailyCDN;
        }
        return preCDN;
    }

    public String getDomain(String val) {
        if (ZenEnvironment.isOnline()) {
            return "//a.yimiyisu.com/" + ZenEnvironment.getAppName() + "/" + ZenEnvironment.getTag() + "/" + val;
        }
        if (ZenEnvironment.isDev()) {
            return "//cdn-dev.yimiyisu.com/" + ZenEnvironment.getAppName() + "/" + val;
        }
        if (ZenEnvironment.isDaily()) {
            return "//cdn-daily.yimiyisu.com/" + ZenEnvironment.getAppName() + "/" + val;
        }
        return "//cdn.pre.zeto.me/" + ZenEnvironment.getAppName() + "/" + val;
    }

    public void setExprList(ExprList exprList) {
        if (exprList.length() > 0) {
            this.val = exprList.getFirstExpr().toString();
        }
    }

    public void exec(Env env, Scope scope, Writer writer) {
        if (ZenEnvironment.isLocalApp()) {
            this.write(writer, "");
        } else if (this.val == null) {
            this.write(writer, this.getDomain());
        } else {
            this.write(writer, this.getDomain(this.val));
        }
    }
}

