/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.kit;

import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.zeto.ZenEnvironment;
import com.zeto.dal.DBHelper;
import com.zeto.dal.SiteMapper;
import com.zeto.domain.ZenApp;
import com.zeto.domain.ZenSite;
import com.zeto.kit.driver.ConfigOptionVO;
import com.zeto.kit.driver.ConfigVO;
import com.zeto.kit.driver.FileConfigDriver;
import com.zeto.kit.driver.IConfigDriver;
import com.zeto.kit.driver.MysqlConfigDriver;
import com.zeto.kit.driver.OptionValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigKit {
    private static final Logger log = LoggerFactory.getLogger(ConfigKit.class);
    private static IConfigDriver configDriver;

    public static boolean addBySite(String siteId, String name, String title, int type) {
        return configDriver.add(siteId, name, title, type, false);
    }

    public static boolean addByApp(String appName, String name, String title, int type) {
        return configDriver.add(appName, name, title, type, true);
    }

    public static void setBySite(String siteId, String name, List<ConfigOptionVO> data) {
        configDriver.set(siteId, name, data, false);
        ZenSite site = SiteMapper.i().getById(siteId);
        SiteMapper.i().removeCache(site);
    }

    public static void setBySite(String siteId, String name, OptionValue data) {
        configDriver.set(siteId, name, data, false);
        ZenSite site = SiteMapper.i().getById(siteId);
        SiteMapper.i().removeCache(site);
    }

    public static void setByApp(String app, String name, List<ConfigOptionVO> data) {
        configDriver.set(app, name, data, true);
        ZenEnvironment.refreshAppConfig();
    }

    public static void setByApp(String app, String name, OptionValue data) {
        configDriver.set(app, name, data, true);
        ZenEnvironment.refreshAppConfig();
    }

    public static String get(String name) {
        String content;
        if (ZenEnvironment.isMulti() && (content = ConfigKit.getBySite(name)) != null) {
            return content;
        }
        return ConfigKit.getByApp(name);
    }

    public static String get(String group, String name) {
        List<ConfigOptionVO> map = ConfigKit.getGroup(group);
        if (map == null) {
            return null;
        }
        for (ConfigOptionVO optionVO : map) {
            if (!optionVO.getKey().equals(name)) continue;
            return optionVO.getValue();
        }
        return null;
    }

    public static List<ConfigOptionVO> getGroup(String name) {
        List<ConfigOptionVO> config;
        if (ZenEnvironment.isMulti() && (config = ConfigKit.getGroupBySite(name)) != null) {
            return config;
        }
        return ConfigKit.getGroupByApp(name);
    }

    public static String getBySite(String name) {
        ZenSite site = WebContext.get().getZenSite();
        if (site == null) {
            return null;
        }
        OptionValue optionValue = site.config(name);
        if (optionValue == null) {
            return null;
        }
        if (ZenEnvironment.isOnline()) {
            return optionValue.getOnline();
        }
        if (ZenEnvironment.isPre()) {
            return optionValue.getPre();
        }
        return optionValue.getDaily();
    }

    public static List<ConfigOptionVO> getGroupBySite(String name) {
        ZenSite site = WebContext.get().getZenSite();
        if (site == null) {
            return null;
        }
        return site.group(name);
    }

    public static String getByApp(String group, String name) {
        List<ConfigOptionVO> configOptionVOList = ConfigKit.getGroupByApp(group);
        for (ConfigOptionVO optionVO : configOptionVOList) {
            if (!optionVO.getKey().equals(name)) continue;
            return optionVO.getValue();
        }
        return null;
    }

    public static String getByApp(String name) {
        OptionValue optionValue = ZenEnvironment.getApp().config(name);
        if (optionValue == null) {
            return null;
        }
        if (ZenEnvironment.isOnline()) {
            return optionValue.getOnline();
        }
        if (ZenEnvironment.isPre()) {
            return optionValue.getPre();
        }
        return optionValue.getDaily();
    }

    public static List<ConfigOptionVO> getGroupByApp(String name) {
        return ZenEnvironment.getApp().group(name);
    }

    public static List<ConfigVO> selectBySite(String siteId) {
        ZenSite zenSite = SiteMapper.i().getById(siteId);
        if (zenSite == null) {
            return null;
        }
        return zenSite.getConfigs();
    }

    public static List<ConfigVO> selectByApp(String appName) {
        ZenApp zenApp = DBHelper.getApp(appName);
        if (zenApp == null) {
            return null;
        }
        return zenApp.getConfigs();
    }

    public static void removeBySite(String siteId, String name) {
        configDriver.remove(siteId, name, false);
    }

    public static void removeByApp(String appName, String name) {
        configDriver.remove(appName, name, true);
    }

    public static void init(String path) {
        Properties pps = new Properties();
        String appConfig = "/etc/zeto/zen.properties";
        File propFile = new File(appConfig);
        try {
            if (propFile.exists()) {
                pps.load(new FileInputStream(appConfig));
            } else {
                appConfig = "D:\\data\\zen.properties";
                propFile = new File(appConfig);
                if (propFile.exists()) {
                    pps.load(new FileInputStream(appConfig));
                }
            }
            ConfigKit.setEnviroment(pps);
            appConfig = path + "/app.properties";
            propFile = new File(appConfig);
            if (propFile.exists()) {
                pps.load(new FileInputStream(appConfig));
                ConfigKit.setEnviroment(pps);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ZenEnvironment.isMulti()) {
            configDriver = new MysqlConfigDriver();
            return;
        }
        String env = ZenEnvironment.get("env", "dev");
        configDriver = env.equals("dev") || env.equals("daily") ? new MysqlConfigDriver() : new FileConfigDriver();
    }

    private static void setEnviroment(Properties pps) {
        if (pps.isEmpty()) {
            return;
        }
        Enumeration<?> enumer = pps.propertyNames();
        while (enumer.hasMoreElements()) {
            String strKey = (String)enumer.nextElement();
            String strValue = pps.getProperty(strKey);
            if (Strings.isNullOrEmpty((String)strValue)) continue;
            ZenEnvironment.set(strKey, strValue);
        }
    }
}

