/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.kit;

import com.blade.kit.GsonKit;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.zeto.ZenEnvironment;
import com.zeto.dal.DBHelper;
import com.zeto.domain.ZenMessageType;
import com.zeto.domain.ZenSite;
import com.zeto.kit.MessageMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MessageKit {
    private String content;
    private int type;
    private String from;
    private List<String> receivers = new ArrayList<String>();
    private String templateId;
    private String relateId;

    private MessageKit() {
    }

    public static MessageKit create(String content, ZenMessageType type) {
        return MessageKit.create(content, type, null);
    }

    public static MessageKit create(String content, ZenMessageType type, String templateId) {
        MessageKit messageKit = new MessageKit();
        messageKit.content = content;
        messageKit.type = type.getValue();
        messageKit.templateId = templateId;
        return messageKit;
    }

    public MessageKit to(String uid) {
        this.receivers.add(uid);
        return this;
    }

    public MessageKit to(List<String> users) {
        this.receivers.addAll(users);
        return this;
    }

    public MessageKit from(String from) {
        this.from = from;
        return this;
    }

    public MessageKit setRelateId(String relateId) {
        this.relateId = relateId;
        return this;
    }

    public boolean send(int time) {
        return this.send(MessageMode.ONICE, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(MessageMode mode, int time) {
        if (this.receivers.size() == 0) {
            return false;
        }
        if (!mode.equals((Object)MessageMode.ONICE) && Strings.isNullOrEmpty((String)this.relateId)) {
            return false;
        }
        ZenSite site = WebContext.get().getZenSite();
        String siteId = site == null ? "" : site.getId();
        String sql = "insert into message(`_id`,`from`,`to`,`content`,`type`,`site_id`,`status`,`app`,`template_id`,`mode`,`time`,`relate_id`)values(?,?,?,?,?,?,?,?,?,?,?,?)";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, StringKit.objectId());
            statement.setString(2, this.from);
            statement.setString(3, GsonKit.stringify(this.receivers));
            statement.setString(4, this.content);
            statement.setInt(5, this.type);
            statement.setString(6, siteId);
            statement.setInt(7, 0);
            statement.setString(8, ZenEnvironment.getAppName());
            statement.setString(9, this.templateId);
            statement.setInt(10, mode.getValue());
            statement.setInt(11, time);
            statement.setString(12, this.relateId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return true;
    }

    public boolean send() {
        return this.send(MessageMode.ONICE, 0);
    }
}

