/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.kit;

import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.ZenUserKit;
import com.zeto.dal.SiteMapper;
import com.zeto.dal.UserSiteMapper;
import com.zeto.domain.ZenRole;
import com.zeto.domain.ZenSite;
import com.zeto.domain.ZenSiteUser;
import com.zeto.domain.ZenUser;
import com.zeto.driver.mongodb.MClient;
import com.zeto.kit.TagKit;
import com.zeto.kit.driver.TagModel;
import java.util.List;

public class SiteKit {
    public static ZenSite get(String id) {
        return SiteMapper.i().getById(id);
    }

    public static ZenSite getByName(String name) {
        return SiteMapper.i().getByName(name);
    }

    public static ZenSiteUser getSiteUser(String uid, String siteId) {
        return UserSiteMapper.i().getSiteUser(uid, siteId);
    }

    public static ZenSite create(String app, String title, String uid, Long userTag) {
        return SiteKit.create(null, title, app, uid, userTag);
    }

    public static Long getRole(String uid, String siteId) {
        ZenSiteUser siteUser = SiteKit.getSiteUser(uid, siteId);
        if (siteUser == null) {
            return 0L;
        }
        return siteUser.getTag();
    }

    public static ZenSite create(String name, String title, String app, String uid, Long userTag) {
        String id = StringKit.objectId();
        if (Strings.isNullOrEmpty((String)name)) {
            name = id.substring(0, 8) + id.substring(20);
        }
        ZenSite site = new ZenSite(null);
        site.setId(id);
        site.setName(name);
        site.setTitle(title);
        site.setApp(app);
        site.setTitle(title);
        site.setTag(TagKit.set(1).value());
        SiteMapper.i().add(site);
        UserSiteMapper.i().add(uid, id, app, userTag);
        return site;
    }

    public static List<ZenUser> selectBySiteId(String siteId, int page) {
        return UserSiteMapper.i().selectBySite(siteId, page);
    }

    public static long countBySiteId(String siteId) {
        return UserSiteMapper.i().countBySite(siteId);
    }

    public static void setTag(ZenSite site, int tag) {
        SiteMapper.i().updateTag(site, tag);
    }

    public static List<ZenUser> selectAdmins(String siteId) {
        return UserSiteMapper.i().selectAdmins(siteId);
    }

    public static boolean setAdmin(String siteId, String uid) {
        return SiteKit.setUserTag(uid, siteId, ZenRole.ADMIN.value());
    }

    public static void quit(String uid, String siteId) {
        UserSiteMapper.i().delete(uid, siteId);
    }

    public static List<ZenSite> selectSitesByUid(String app, String uid) {
        return UserSiteMapper.i().selectByUid(app, uid);
    }

    public static ZenResult selectUsersByRole(String siteId, ZenRole role) {
        return UserSiteMapper.i().selectUserWithTag(siteId, role);
    }

    public static List<ZenSite> selectByUidWithTag(String app, String uid, int tag) {
        return UserSiteMapper.i().selectByUidWithTag(app, uid, tag);
    }

    public static boolean addUser(String uid, Long userTag) {
        ZenSite site = WebContext.get().getZenSite();
        if (site == null) {
            return false;
        }
        return SiteKit.addUser(uid, site, userTag);
    }

    public static boolean addUser(String uid, ZenSite site, Long userTag) {
        UserSiteMapper.i().add(uid, site.getId(), site.getApp(), userTag);
        return true;
    }

    public static boolean setUserTag(String uid, String siteId, TagModel tagModel) {
        ZenSiteUser siteUser = UserSiteMapper.i().getSiteUser(uid, siteId);
        if (siteUser == null) {
            return false;
        }
        Long tagValue = siteUser.getTag();
        for (int tag : tagModel.getTags()) {
            tagValue = TagKit.set(tagValue, tag);
        }
        UserSiteMapper.i().updateTag(uid, siteId, tagValue);
        ZenUserKit.cleanCache(uid);
        return true;
    }

    public static String getUserDeviceId(String uid, String siteId) {
        return UserSiteMapper.i().getDeviceId(uid, siteId);
    }

    public static void updateUserDeviceId(String uid, String siteId, String deviceId) {
        UserSiteMapper.i().updateDeviceId(uid, siteId, deviceId);
    }

    public static void updateUserAliasId(String uid, String siteId, String aliasId) {
        UserSiteMapper.i().updateAlias(uid, siteId, aliasId);
    }

    public static boolean setUserTag(String uid, String siteId, int tag) {
        ZenSiteUser siteUser = UserSiteMapper.i().getSiteUser(uid, siteId);
        if (siteUser == null) {
            return false;
        }
        Long tagValue = siteUser.getTag();
        tagValue = TagKit.set(tagValue, tag);
        UserSiteMapper.i().updateTag(uid, siteId, tagValue);
        return true;
    }

    public static ZenSite getLastSite(String app, String uid, int tag) {
        return SiteMapper.i().getLastSite(app, uid, tag);
    }

    public static boolean removeAdmin(String siteId, String uid) {
        return SiteKit.setUserTag(uid, siteId, 0 - ZenRole.ADMIN.value());
    }

    public static void updateVisit(String uid, String siteId) {
        UserSiteMapper.i().updateVisit(uid, siteId);
    }

    public static boolean isAdmin(String uid, String siteId) {
        ZenSiteUser siteUser = SiteKit.getSiteUser(uid, siteId);
        if (siteUser == null) {
            return false;
        }
        Long tagValue = siteUser.getTag();
        return TagKit.contain(tagValue, ZenRole.ADMIN.value());
    }

    public static void drop(ZenSite site) {
        if (ZenEnvironment.isOnline() || ZenEnvironment.isPre()) {
            return;
        }
        if (!site.containTag(1)) {
            return;
        }
        SiteMapper.i().delete(site.getId());
        UserSiteMapper.i().clean(site.getId());
        MClient.drop(site);
    }

    public static void changeDomain(String domain, String siteId, String uid) {
        if (!SiteKit.isAdmin(uid, siteId)) {
            return;
        }
    }
}

