/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.kit.driver;

import com.blade.kit.GsonKit;
import com.zeto.ZenEnvironment;
import com.zeto.kit.driver.ConfigOptionVO;
import com.zeto.kit.driver.ConfigVO;
import com.zeto.kit.driver.IConfigDriver;
import com.zeto.kit.driver.OptionValue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigDriver
implements IConfigDriver {
    private static final Logger log = LoggerFactory.getLogger(FileConfigDriver.class);

    @Override
    public boolean add(String siteId, String name, String title, int type, boolean isApp) {
        return false;
    }

    @Override
    public void set(String key, String name, OptionValue value, boolean isApp) {
        List<ConfigVO> data = ZenEnvironment.getApp().getConfigs();
        ConfigVO configVO = this.get(data, name);
        if (configVO == null || configVO.getType() != 0) {
            return;
        }
        configVO.setValue(value);
        this.update(data);
    }

    @Override
    public void set(String key, String name, ConfigOptionVO optionVO, boolean isApp) {
        List<ConfigVO> data = ZenEnvironment.getApp().getConfigs();
        ConfigVO configVO = this.get(data, name);
        if (configVO == null || configVO.getType() != 1) {
            return;
        }
        configVO.addOption(optionVO);
        this.update(data);
    }

    @Override
    public void set(String key, String name, List<ConfigOptionVO> optionVOS, boolean isApp) {
        List<ConfigVO> data = ZenEnvironment.getApp().getConfigs();
        ConfigVO configVO = this.get(data, name);
        if (configVO == null) {
            configVO = new ConfigVO();
            configVO.setType(1);
            configVO.setName(name);
            configVO.setOptions(optionVOS);
            data = new ArrayList<ConfigVO>();
            data.add(configVO);
        } else {
            configVO.setOptions(optionVOS);
        }
        this.update(data);
    }

    private ConfigVO get(List<ConfigVO> configs, String name) {
        if (configs == null) {
            return null;
        }
        for (ConfigVO configVO : configs) {
            if (!configVO.getName().equals(name)) continue;
            return configVO;
        }
        return null;
    }

    private void update(List<ConfigVO> data) {
        String path = ZenEnvironment.getPath() + "/config/app.config";
        File file = new File(path);
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileWriter writer = new FileWriter(file);
            writer.write(GsonKit.stringify(data));
            writer.close();
        }
        catch (IOException e) {
            log.error("file error", (Throwable)e);
        }
        ZenEnvironment.getApp().reload();
    }

    @Override
    public void remove(String siteId, String name, boolean isApp) {
    }
}

