/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.kit.driver;

import com.blade.kit.GsonKit;
import com.zeto.dal.DBHelper;
import com.zeto.kit.ConfigKit;
import com.zeto.kit.driver.ConfigOptionVO;
import com.zeto.kit.driver.ConfigVO;
import com.zeto.kit.driver.IConfigDriver;
import com.zeto.kit.driver.OptionValue;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MysqlConfigDriver
implements IConfigDriver {
    @Override
    public boolean add(String key, String name, String title, int type, boolean isApp) {
        List<ConfigVO> data = isApp ? ConfigKit.selectByApp(key) : ConfigKit.selectBySite(key);
        ConfigVO configVO = this.get(data, name);
        if (configVO != null) {
            return false;
        }
        configVO = new ConfigVO();
        configVO.setType(type);
        configVO.setTitle(title);
        configVO.setName(name);
        data.add(configVO);
        this.update(data, key, isApp);
        return true;
    }

    @Override
    public void remove(String key, String name, boolean isApp) {
        List<ConfigVO> data = isApp ? ConfigKit.selectByApp(key) : ConfigKit.selectBySite(key);
        for (int i = 0; i < data.size(); ++i) {
            ConfigVO configVO = data.get(i);
            if (!configVO.getName().equals(name)) continue;
            data.remove(i);
            break;
        }
        this.update(data, key, isApp);
    }

    @Override
    public void set(String key, String name, OptionValue value, boolean isApp) {
        List<ConfigVO> data = isApp ? ConfigKit.selectByApp(key) : ConfigKit.selectBySite(key);
        ConfigVO configVO = this.get(data, name);
        if (configVO == null || configVO.getType() != 0) {
            return;
        }
        configVO.setValue(value);
        this.update(data, key, isApp);
    }

    @Override
    public void set(String key, String name, ConfigOptionVO optionVO, boolean isApp) {
        List<ConfigVO> data = isApp ? ConfigKit.selectByApp(key) : ConfigKit.selectBySite(key);
        ConfigVO configVO = this.get(data, name);
        if (configVO == null || configVO.getType() != 1) {
            return;
        }
        configVO.addOption(optionVO);
        this.update(data, key, isApp);
    }

    @Override
    public void set(String key, String name, List<ConfigOptionVO> optionVOS, boolean isApp) {
        List<ConfigVO> data;
        if (isApp) {
            data = ConfigKit.selectByApp(key);
        } else {
            data = ConfigKit.selectBySite(key);
            if (data == null) {
                data = new ArrayList<ConfigVO>();
            }
        }
        ConfigVO configVO = this.get(data, name);
        if (configVO == null) {
            configVO = new ConfigVO();
            configVO.setType(1);
            configVO.setName(name);
            configVO.setOptions(optionVOS);
            data = new ArrayList<ConfigVO>();
            data.add(configVO);
        } else {
            configVO.setOptions(optionVOS);
        }
        this.update(data, key, isApp);
    }

    private ConfigVO get(List<ConfigVO> configs, String name) {
        for (ConfigVO configVO : configs) {
            if (!configVO.getName().equals(name)) continue;
            return configVO;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(List<ConfigVO> data, String key, boolean isApp) {
        String sql = isApp ? "update app set config=? where name=? limit 1" : "update site set config=? where _id=? limit 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, GsonKit.stringify(data));
            statement.setString(2, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }
}

