/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Map;

public class ClassWrap {
    public static <T> T toJavaObject(Object obj, Class<T> clazz) {
        return (T)TypeUtils.cast((Object)obj, clazz, (ParserConfig)ParserConfig.getGlobalInstance());
    }

    private static <T> T cast(Object obj, Class<T> clazz, ParserConfig config) {
        if (obj == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            Map map = (Map)obj;
            if (clazz == Object.class && !map.containsKey(JSON.DEFAULT_TYPE_KEY)) {
                return (T)obj;
            }
            return ClassWrap.castToJavaBean((Map)obj, clazz, config);
        }
        if (clazz.isArray()) {
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                int index = 0;
                Object array = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object item : collection) {
                    Object value = ClassWrap.cast(item, clazz.getComponentType(), config);
                    Array.set(array, index, value);
                    ++index;
                }
                return (T)array;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtils.castToBytes((Object)obj);
            }
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean((Object)obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte((Object)obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort((Object)obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt((Object)obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong((Object)obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat((Object)obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble((Object)obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString((Object)obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal((Object)obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger((Object)obj);
        }
        if (clazz == java.util.Date.class) {
            return (T)TypeUtils.castToDate((Object)obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToSqlDate((Object)obj);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp((Object)obj);
        }
        if (clazz.isEnum()) {
            return (T)TypeUtils.castToEnum((Object)obj, clazz, (ParserConfig)config);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            java.util.Date date = TypeUtils.castToDate((Object)obj);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new JSONException("can not cast to : " + clazz.getName(), (Throwable)e);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        if (obj instanceof String) {
            String strVal = (String)obj;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (clazz == Currency.class) {
                return (T)Currency.getInstance(strVal);
            }
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    private static <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig config) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : value.intValue();
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get(JSON.DEFAULT_TYPE_KEY);
            if (iClassObject instanceof String) {
                String className = (String)iClassObject;
                Class loadClazz = TypeUtils.loadClass((String)className);
                if (loadClazz == null) {
                    throw new ClassNotFoundException(className + " not found");
                }
                if (!loadClazz.equals(clazz)) {
                    return ClassWrap.castToJavaBean(map, loadClazz, config);
                }
            }
            if (clazz.isInterface()) {
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
            }
            if (config == null) {
                config = ParserConfig.getGlobalInstance();
            }
            JavaBeanDeserializer javaBeanDeser = null;
            ObjectDeserializer deserizer = config.getDeserializer(clazz);
            if (deserizer instanceof JavaBeanDeserializer) {
                javaBeanDeser = (JavaBeanDeserializer)deserizer;
            }
            if (javaBeanDeser == null) {
                throw new JSONException("can not get javaBeanDeserializer");
            }
            return (T)javaBeanDeser.createInstance(map, config);
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), (Throwable)e);
        }
    }
}

