/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.util;

import com.blade.kit.StringKit;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.Request;
import com.google.common.base.Strings;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.ZenUserKit;
import com.zeto.domain.ZenUser;
import java.util.List;
import java.util.Map;

public class RequestUtil {
    private static final String uidName = "Uid";
    private static final String ukeyName = "Ukey";

    public static ZenUser getUser(Request request) {
        Map<String, Cookie> cookies = request.cookies();
        String uid = request.header(uidName);
        String ukey = request.header(ukeyName);
        if (Strings.isNullOrEmpty((String)uid) && cookies != null) {
            if (cookies.containsKey(uidName)) {
                uid = cookies.get(uidName).value();
            }
            if (cookies.containsKey(ukeyName)) {
                ukey = cookies.get(ukeyName).value();
            }
        }
        if (StringKit.isBlank(uid) || StringKit.isBlank(ukey) || ZenEnvironment.isNoSetup()) {
            return null;
        }
        ZenUser zenUser = ZenUserKit.get(uid);
        if (zenUser == null) {
            return null;
        }
        if (ukey.equals(zenUser.getUkey())) {
            return zenUser;
        }
        return null;
    }

    public static String jsGOTO(ZenResult result) {
        List<Cookie> cookies = result.getCookies();
        String storage = "";
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                storage = storage + "win.localStorage['" + cookie.name() + "'] = '" + cookie.value() + "';";
            }
        }
        String url = result.getMessage();
        return "<!DOCTYPE html>\n<html>\n  <head>\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n    <meta name=\"renderer\" content=\"webkit\" />\n    <meta\n      name=\"viewport\"\n      content=\"width=device-width,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no\"\n    />\n  </head>\n  <body>\n    \u6b63\u5728\u52a0\u8f7d\u4e2d...\n    <script>\n      let win = window;\n" + storage + "      win.location = '" + url + " '\n    </script>\n  </body>\n</html>";
    }
}

