/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.File;
import java.time.format.DateTimeFormatter;
import org.slf4j.helpers.Util;
import org.slf4j.impl.FileRunner;
import org.slf4j.impl.OutputChoice;
import org.slf4j.impl.utils.LogUtils;

public class SimpleLoggerConfiguration {
    DateTimeFormatter dateFormatter = null;
    OutputChoice outputChoice = null;
    boolean showLogName = false;
    boolean showShortLogName = true;
    boolean levelInBrackets = false;
    boolean showThreadName = true;
    boolean showDateTime = true;
    boolean showConsole = true;
    boolean disableColor = false;
    int defaultLogLevel = 30;
    FileRunner fileRunner;

    void init(String logName, String logDir) {
        if (LogUtils.isEmpty(logDir)) {
            this.outputChoice = SimpleLoggerConfiguration.computeOutputChoice(logDir, false);
        } else {
            if (logDir.endsWith(".jar")) {
                logDir = System.getenv("user.dir");
            }
            if (logName.isEmpty()) {
                logName = "app";
            }
            long maxSize = 0x6400000L;
            String logFilePath = logDir + File.separator + logName;
            this.outputChoice = SimpleLoggerConfiguration.computeOutputChoice(logFilePath, false);
            this.fileRunner = new FileRunner(logName, logDir, maxSize);
            Thread thread = new Thread(this.fileRunner);
            thread.setName("blade-logging");
            thread.setDaemon(true);
            thread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.fileRunner.close()));
        }
        try {
            this.dateFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        }
        catch (IllegalArgumentException e) {
            Util.report((String)"Bad date format in application; will output relative time", (Throwable)e);
        }
    }

    static int stringToLevel(String levelStr) {
        if ("trace".equalsIgnoreCase(levelStr)) {
            return 0;
        }
        if ("debug".equalsIgnoreCase(levelStr)) {
            return 10;
        }
        if ("info".equalsIgnoreCase(levelStr)) {
            return 20;
        }
        if ("warn".equalsIgnoreCase(levelStr)) {
            return 30;
        }
        if ("error".equalsIgnoreCase(levelStr)) {
            return 40;
        }
        if ("error".equalsIgnoreCase(levelStr)) {
            return 50;
        }
        return 20;
    }

    private static OutputChoice computeOutputChoice(String logFilePath, boolean cacheOutputStream) {
        if ("System.err".equalsIgnoreCase(logFilePath)) {
            if (cacheOutputStream) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_ERR);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_ERR);
        }
        if ("System.out".equalsIgnoreCase(logFilePath)) {
            if (cacheOutputStream) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_OUT);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_OUT);
        }
        return new OutputChoice(OutputChoice.OutputChoiceType.FILE);
    }
}

