package com.zeto.kooteam.util;

import com.google.common.base.Strings;

public class Email {
    private final static String template = "<!doctype html><html><head><meta name=\"viewport\" content=\"width=device-width\" /><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n" +
            "    <style>.article-body{padding:22px 15px 40px;min-height:300px;outline:none;cursor:text;position:relative;z-index:1;background:transparent;font-family:arial, sans-serif;line-height:1.6;color:#333;word-wrap:break-word}.article-body a.selected{background:#b3d4fd}.article-body a.simditor-mention{cursor:pointer}.article-body .simditor-table{position:relative}.article-body .simditor-table.resizing{cursor:col-resize}.article-body .simditor-table .simditor-resize-handle{position:absolute;left:0;top:0;width:10px;height:100%;cursor:col-resize}.article-body pre{box-sizing:border-box;-moz-box-sizing:border-box;word-wrap:break-word !important;white-space:pre-wrap !important}.article-body img{cursor:pointer}.article-body img.selected{box-shadow:0 0 0 4px #ccc}.article-body > :first-child{margin-top:0 !important}.article-body a{color:#4298BA;text-decoration:none;word-break:break-all}.article-body a:visited{color:#4298BA}.article-body a:hover{color:#0F769F;outline:0}.article-body a:active{outline:0;color:#9E792E}.article-body h1,.article-body h2,.article-body h3,.article-body h4,.article-body h5,.article-body h6{margin:40px 0 20px;color:#000}.article-body h1,.article-body h2,.article-body h3{border-bottom:1px solid #eaecef}.article-body h1{font-size:24px}.article-body h2{font-size:22px}.article-body h3{font-size:20px;font-weight:normal;padding:.4rem 0 .4rem .6rem;position:relative}.article-body h4{font-size:18px}.article-body h5{font-size:16px}.article-body h6{font-size:16px}.article-body p,.article-body div{word-wrap:break-word;margin:0 0 15px 0;color:#333}.article-body b,.article-body strong{font-weight:bold}.article-body i,.article-body em{font-style:italic}.article-body u{text-decoration:underline}.article-body strike,.article-body del{text-decoration:line-through}.article-body ul,.article-body ol{list-style:disc outside none;margin:15px 0;padding:0 0 0 40px;line-height:1.6}.article-body ul li,.article-body ol li{list-style-type:inherit}.article-body ul ul,.article-body ul ol,.article-body ol ul,.article-body ol ol{padding-left:30px}.article-body ul ul,.article-body ol ul{list-style:circle outside none}.article-body ul ul ul,.article-body ol ul ul{list-style:square outside none}.article-body ol{list-style:decimal}.article-body blockquote{border-left:6px solid #ddd;padding:5px 0 5px 10px;margin:15px 0 15px 15px}.article-body blockquote > :first-child{margin-top:0}.article-body code{display:inline-block;padding:0 4px;margin:0 5px;background:#eee;border-radius:3px;font-size:13px;font-family:'monaco', 'Consolas', \"Liberation Mono\", Courier, monospace;word-break:break-all;word-wrap:break-word}.article-body pre{padding:10px 5px 10px 10px;margin:15px 0;display:block;line-height:18px;background:#F0F0F0;border-radius:3px;font-size:13px;font-family:'monaco', 'Consolas', \"Liberation Mono\", Courier, monospace;white-space:pre;word-wrap:normal;overflow-x:auto}.article-body pre code{display:block;padding:0;margin:0;background:none;border-radius:0}.article-body hr{display:block;height:0;border:0;border-top:1px solid #ccc;margin:15px 0;padding:0}.article-body table{width:100%;table-layout:fixed;border-collapse:collapse;border-spacing:0;margin:15px 0}.article-body table thead{background-color:#f9f9f9}.article-body table td,.article-body table th{min-width:40px;height:30px;border:1px solid #ccc;vertical-align:top;padding:2px 4px;text-align:left;box-sizing:border-box}.article-body table td.active,.article-body table th.active{background-color:#ffe}.article-body img{margin:0 5px;vertical-align:middle}</style>\n" +
            "  </head><body><div class=\"article-body\">${content}</div></body></html>";


    public static String getTemplate(String content) {
        if (Strings.isNullOrEmpty(content)) {
            return null;
        }
        return template.replace("${content}", content);
    }
}
