let users = [
	{
		"uuid": "08c0a6ec-a42b-47b2-bb1e-15e0f5f9a19a",
		"username": "Mattie",
		"password": "123",
		"avatar": '/images/Avatar-1.png'
	},
	{
		"uuid": "3bb179af-bcc5-4fe0-9dac-c05688484649",
		"username": "Wallace",
		"password": "123",
		"avatar": '/images/Avatar-2.png'
	},
	{
		"uuid": "fdee46b0-4b01-4590-bdba-6586d7617f95",
		"username": "Tracy",
		"password": "123",
		"avatar":'/images/Avatar-3.png'
	},
	{
		"uuid": "33c3693b-dbb0-4bc9-99c6-fa77b9eb763f",
		"username": "Juanita",
		"password": "123",
		"avatar": '/images/Avatar-4.png'
	}
];

let friends = [
	{
		"userUUID": "08c0a6ec-a42b-47b2-bb1e-15e0f5f9a19a",
		"friendUUID": "3bb179af-bcc5-4fe0-9dac-c05688484649",
		"sessionID": "012247ce-dca7-4f4f-84f9-de4cfd614380"
	},
	{
		"userUUID": "08c0a6ec-a42b-47b2-bb1e-15e0f5f9a19a",
		"friendUUID": "fdee46b0-4b01-4590-bdba-6586d7617f95",
		"sessionID": "bdbdbe44-5fd3-4b20-98a3-93413242180c"
	},
	{
		"userUUID": "08c0a6ec-a42b-47b2-bb1e-15e0f5f9a19a",
		"friendUUID": "33c3693b-dbb0-4bc9-99c6-fa77b9eb763f",
		"sessionID": "608416da-263d-4701-b5b5-e9e613802e74"
	},

	{
		"userUUID": "3bb179af-bcc5-4fe0-9dac-c05688484649",
		"friendUUID": "08c0a6ec-a42b-47b2-bb1e-15e0f5f9a19a",
		"sessionID": "012247ce-dca7-4f4f-84f9-de4cfd614380"
	},
	{
		"userUUID": "3bb179af-bcc5-4fe0-9dac-c05688484649",
		"friendUUID": "fdee46b0-4b01-4590-bdba-6586d7617f95",
		"sessionID": "662e5fd3-f3d3-4d76-8a6b-0a5da5bcf50a"
	},
	{
		"userUUID": "3bb179af-bcc5-4fe0-9dac-c05688484649",
		"friendUUID": "33c3693b-dbb0-4bc9-99c6-fa77b9eb763f",
		"sessionID": "db5e39a6-70c4-4650-b595-fb007fb3033d"
	},

	{
		"userUUID": "fdee46b0-4b01-4590-bdba-6586d7617f95",
		"friendUUID": "08c0a6ec-a42b-47b2-bb1e-15e0f5f9a19a",
		"sessionID": "bdbdbe44-5fd3-4b20-98a3-93413242180c"
	},
	{
		"userUUID": "fdee46b0-4b01-4590-bdba-6586d7617f95",
		"friendUUID": "3bb179af-bcc5-4fe0-9dac-c05688484649",
		"sessionID": "662e5fd3-f3d3-4d76-8a6b-0a5da5bcf50a"
	},
	{
		"userUUID": "fdee46b0-4b01-4590-bdba-6586d7617f95",
		"friendUUID": "33c3693b-dbb0-4bc9-99c6-fa77b9eb763f",
		"sessionID": "dc91cb25-80c9-4db6-84f2-7c15969763c8"
	},

	{
		"userUUID": "33c3693b-dbb0-4bc9-99c6-fa77b9eb763f",
		"friendUUID": "08c0a6ec-a42b-47b2-bb1e-15e0f5f9a19a",
		"sessionID": "608416da-263d-4701-b5b5-e9e613802e74"
	},
	{
		"userUUID": "33c3693b-dbb0-4bc9-99c6-fa77b9eb763f",
		"friendUUID": "3bb179af-bcc5-4fe0-9dac-c05688484649",
		"sessionID": "db5e39a6-70c4-4650-b595-fb007fb3033d"
	},
	{
		"userUUID": "33c3693b-dbb0-4bc9-99c6-fa77b9eb763f",
		"friendUUID": "fdee46b0-4b01-4590-bdba-6586d7617f95",
		"sessionID": "dc91cb25-80c9-4db6-84f2-7c15969763c8"
	}
];

function RestApi() {

}

RestApi.findUser = function (username, password) {
	for (let i = 0; i < users.length; i++) {
		if (username == users[i].username && password == users[i].password) {
			return users[i];
		}
	}
	return null;
};

RestApi.findChatHistory =function(currentUserUUID, friendUUID) {
	let localStorageKey = currentUserUUID + "." + friendUUID;
	let friendChatHistoryAsString = localStorage.getItem(localStorageKey);
	if (friendChatHistoryAsString != null) {
		let friendChatHistory = JSON.parse(friendChatHistoryAsString);
		return friendChatHistory;
	}
	return [];
};

RestApi.findFriends = function(userUUID) {
	let friendsList = [];
	friends.forEach(function(friend) {
		if (friend.userUUID == userUUID) {
			users.forEach(function(user) {
				if (user.uuid == friend.friendUUID) {
					friend.username = user.username;
					friend.avatar = user.avatar;
				}
			})
			friendsList.push(friend);
		}
	});
	return friendsList;
};

RestApi.saveChatMessage = function(currentUserUUID,friendUUID, chatMessage) {
	let localStorageKey = currentUserUUID + "." + friendUUID;
	let friendChatHistoryAsString = localStorage.getItem(localStorageKey);
	let friendChatHistory;
	if (friendChatHistoryAsString == null || friendChatHistoryAsString == "") {
		friendChatHistory = [];
	} else {
		friendChatHistory = JSON.parse(friendChatHistoryAsString);
	}
	friendChatHistory.push(chatMessage);
	friendChatHistoryAsString = JSON.stringify(friendChatHistory);
	localStorage.setItem(localStorageKey, friendChatHistoryAsString);
};

export default RestApi;
