import Vue from 'vue';
import Router from 'vue-router';
import Login from "../views/Login";
import FriendList from "../views/FriendList";
import Chat from "../views/Chat";

Vue.use(Router);


const router = new Router({
    routes : [
        {
            path : '/',
            name : 'login',
            component : Login
        },
        {
            path : '/friendlist',
            name : 'friendlist',
            component: FriendList
        },
        {
            path : '/chat',
            name : 'chat',
            component : Chat
        }
    ]
});

router.beforeEach((to, from, next) => {
    if(!Vue.prototype.imService.currentUser && to.name !="login"){
        next("/")
    }
    next()
});

export default router;