Set FSO = CreateObject("Scripting.FileSystemObject")
Set SDO = CreateObject("Scripting.Dictionary")
Dim TextFile, ToPage, UPage, Tristate
Dim VarPage(40000)
NowPath = Replace(WScript.ScriptFullName, WScript.ScriptName, "")
IniPath = NowPath & "LookBook.ini"
Randomize
FileEx = tfFile(IniPath)

'
If Not FileEx Then
	Set IniFile = FSO.OpenTextFile(IniPath, 2, Not FileEx, False)
	With IniFile
		.WriteLine "[Main]"
		.WriteLine "MeName=LookBookư"
		.WriteLine "MaxLen=1024"
		.WriteLine "MaxLine=30"
		.Close
	End With
	Set IniFile = Nothing
End If

Set IniFile = FSO.OpenTextFile(IniPath, 1, False, False)

For Each LineIni In Split(IniFile.ReadAll, vbCrLf)
	TempData = Split(LineIni, "=")
	If UBound(TempData) >= 1 Then
		If Not SDO.Exists(TempData(0)) Then
			TempVal = Join(MidArr(TempData, 1, True), "=")
			Select Case UCase(TempData(0))
			Case UCase("MeName")
				ExeCute "Const MeName  = """ & TempVal & """"
			Case UCase("MaxLen")
				TempVal = CInt(IIf(IsNumeric(TempVal), TempVal, 1024))
				If TempVal <= 800 Or TempVal >= 1024 Then TempVal = 1024
				ExeCute "Const MaxLen  = " & TempVal & ""
			Case UCase("MaxLine")
				TempVal = IIf(IsNumeric(TempVal), TempVal, 30)
				If TempVal <= 1 Or TempVal >= 35 Then TempVal = 30
				ExeCute "Const MaxLine = " & TempVal & ""
			Case Else: SDO.Add TempData(0), MidArr(TempData, 1, True)
			End Select
		End If
	End If
Next

If VarType(MeName)  = vbEmpty Then Const MeName  = "LookBookư"
If VarType(MaxLen)  = vbEmpty Then Const MaxLen  = 1024
If VarType(MaxLine) = vbEmpty Then Const MaxLine = 30

'ʼ
Call Main
'



Sub Main()
	Call SelectFile
	
	Select Case InputBox("Ժָʽȡ?" _
						& vbCrLf & " 1.ASCII" _
						& vbCrLf & " 2.Unicode " _
						, MeName, 1)
	
	Case "1" : Tristate = False
	Case "2" : Tristate = True
	Case ""  : Main: Exit Sub
	Case Else: Tristate = False
	End Select
	
	TempText = FSO.OpenTextFile(TextFile, 1, False, Tristate).ReadAll
	
	Erase VarPage
	
	RNCH = "{" & Hex((9999 - 1000 + 1) * Rnd + 1000) & "}"
	InnNum = 1
	
	If Len(TempText) <= MaxLen Then
		VarPage(InnNum) = TempText
	Else
		For Each LineText In Split(TempText, vbCrLf)
			If Not Trim(LineText) = "" Then
				tfCrLf = tfCrLf + 1
				If tfCrLf = MaxLine Then InnNum = InnNum + 1: tfCrLf = 0
				InnNum = InnNum + IIf(Len(VarPage(InnNum) & LineText) > MaxLen, 1, 0)
				VarPage(InnNum) = VarPage(InnNum) & LineText & vbCrLf
			End If
		Next
	End If
	
	UPage = InnNum
	LookBook VarPage
End Sub

Sub LookBook(ByVal Pages)
	ToPage = 1
	Do
		Select Case Msgbox(Pages(ToPage), vbYesNoCancel, "ҳ:" & ToPage & "/" & UPage &" | " & ":һҳ :תҳ ȡ:˳")
		Case vbYes: ToPage = ToPage + 1
		Case vbNo : SelectPage(ToPage)
		Case vbCancel: Main
		Case Else: Main
		End Select
	Loop Until ToPage = UPage + 1
	Msg ""
	Main
End Sub

Sub SelectPage(ByVal NowPage)
	TempData = InputBox("ǰҳ:" & NowPage & vbCrLf & "תҳ 1-" & UPage, "ѡҳ", NowPage)
	If IsNumeric(TempData) Then
		TempData = CInt(TempData)
		If TempData >= 1 And TempData <= UPage Then ToPage = TempData Else Msg "ҳ"
	End If
End Sub

Sub SelectFile()
	tfFE = True
	Set ObjFile = FSO.GetFolder(NowPath)
	
	For Each FL In ObjFile.Files
		If LCase(Right(FL.Name,4)) = ".txt" then
			AddFile = AddFile & vbCrLf & FL.Name
			AddSize = AddSize & vbCrLf & FL.Size
			If tfFE Then tfFE = False
		End If
	Next
	
	If tfFE Then Msg NowPath & " txtļ": WScript.Quit
	
	InnFile = Split(AddFile, vbCrLf)
	InnSize = Split(AddSize, vbCrLf)
	
	For I = 1 To UBound(InnFile)
		ShowFileList = ShowFileList & IIf(I <= 9, "  ", " ") & I & ">|" & InnFile(I) & vbCrLf & _
									"    |	KB:" &InnSize(I) / 1024 & vbCrLf
	Next: I = Empty
	
	GetNum = Inputbox("ǰ·:" & NowPath & vbCrLf & vbCrLf _
			& "|ļ" & vbCrLf _
			& ShowFileList, MeName, 1)
			
	If GetNum = "" Then WScript.Quit
	If IsNumeric(GetNum) Then
		GetNum = CInt(GetNum)
		If GetNum >= 1 And GetNum <= UBound(InnFile) Then
			If tfFile(NowPath & InnFile(GetNum)) = False Then
				Msg "ļ:" & InnFile(GetNum)
			Else
				TextFile = NowPath & InnFile(GetNum)
				Exit Sub
			End If
		Else
			Msg "ųΧ"
		End If
	Else
		Msg "Ųȷ"
	End If
	
	SelectFile
End Sub

Sub Msg(ByVal Text)
	Msgbox Text,, MeName
End Sub

Function MidArr(ByVal GEOM_Array, ByVal GEOM_LB, ByVal GEOM_UB)	
	If TypeName(GEOM_Array) = "Variant()" Then
		GEOM_UB = IIf(GEOM_UB = True, UBound(GEOM_Array), GEOM_UB)
		If GEOM_LB < LBound(GEOM_Array) Or GEOM_UB > UBound(GEOM_Array) Then
			MidArr = Array("޲ȷ")
		Else
			For GEOM_I = GEOM_LB To GEOM_UB
				GEOM_TempDataStr = GEOM_TempDataStr & GEOM_Array(GEOM_I) & IIf(GEOM_UB = GEOM_I, "", vbCrLf)
			Next
			MidArr = Split(GEOM_TempDataStr, vbCrLf)
		End If
	Else
		MidArr = Array("")
	End If
	GEOM_TempDataStr = Empty
End Function

Function IIf(ByVal GEOM_tf, ByVal GEOM_T, ByVal GEOM_F)
	If GEOM_tf Then IIF = GEOM_T Else IIF = GEOM_F
End Function

Function tfFile(ByVal FilePath)
	tfFile = IIf(FSO.FileExists(FilePath) = False, False, True)
End Function