//ϣ,NativeΪö
var Hash = new Native({

 //,,$typeľ׼ж
 name: 'Hash',

 initialize: function(object){

  //ڹϣʵ,ƸԽߵ/ӹϵ
  if ($type(object) == 'hash') bject = $unlink(object.getClean());

  //ٸƵǰʵ
  for (var key in object) this[key] = object[key];
  return this;
 }

});

//Թϣչʵ
Hash.implement({

 //ϣ(ֵͳ,ֵΪ)
 getLength: function(){
  var length = 0;
  for (var key in this){
   //hasOwnPropertyжǷָƵ,ע,
   if (this.hasOwnProperty(key)) length++;
  }
  return length;
 },

 //,ͬʱֻ,Ҳܷʵʹõ
 forEach: function(fn, bind){
  for (var key in this){
   if (this.hasOwnProperty(key)) fn.call(bind, this[key], key, this);
  }
 },
 
 //һ,֪Ϊʲô
 getClean: function(){
  var clean = {};
  for (var key in this){
   if (this.hasOwnProperty(key)) clean[key] = this[key];
  }
  return clean;
 }

});

//eachΪforEachı
Hash.alias('forEach', 'each');

//תΪϣĿݷʽ
function $H(object){
 return new Hash(object);
};

//չ
Hash.implement({

 //hasOwnPropertyĿݷʽ
 has: Object.prototype.hasOwnProperty,

 //ֵҶӦļ
 keyOf: function(value){
  for (var key in this){
   if (this.hasOwnProperty(key) && this[key] === value) return key;
  }
  return null;
 },

 //Ƿֵָ
 hasValue: function(value){
  return (Hash.keyOf(this, value) !== null);
 },

 //չḲԭ
 extend: function(properties){
  Hash.each(properties, function(value, key){
   Hash.set(this, key, value);
  }, this);
  return this;
 },

 //ϲظ
 combine: function(properties){
  Hash.each(properties, function(value, key){
   Hash.include(this, key, value);
  }, this);
  return this;
 },

 //ֵָ̽
 erase: function(key){
  if (this.hasOwnProperty(key)) delete this[key];
  return this;
 },

 //ݼȡֵ
 get: function(key){
  return (this.hasOwnProperty(key)) ? this[key] : null;
 },

 //ü-ֵ
 set: function(key, value){
  if (!this[key] || this.hasOwnProperty(key)) this[key] = value;
  return this;
 },

 //չϣ
 empty: function(){
  Hash.each(this, function(value, key){
   delete this[key];
  }, this);
  return this;
 },

 //¼-ֵвڸü
 include: function(key, value){
  var k = this[key];
  if (!$defined(k)) this[key] = value;
  return this;
 },

 //ArraymapڴfnĲ
 map: function(fn, bind){
  var results = new Hash;
  Hash.each(this, function(value, key){
   results.set(key, fn.call(bind, value, key, this));
  }, this);
  return results;
 },

 //ArrayfilterڴfnĲ
 filter: function(fn, bind){
  var results = new Hash;
  Hash.each(this, function(value, key){
   if (fn.call(bind, value, key, this)) results.set(key, value);
  }, this);
  return results;
 },

 //ArrayeveryڴfnĲ
 every: function(fn, bind){
  for (var key in this){
   if (this.hasOwnProperty(key) && !fn.call(bind, this[key], key)) return false;
  }
  return true;
 },

 //ArraysomeڴfnĲ
 some: function(fn, bind){
  for (var key in this){
   if (this.hasOwnProperty(key) && fn.call(bind, this[key], key)) return true;
  }
  return false;
 },

 //ȡϣем鷵
 getKeys: function(){
  var keys = [];
  Hash.each(this, function(value, key){
   keys.push(key);
  });
  return keys;
 },

 //ȡϣеֵ鷵
 getValues: function(){
  var values = [];
  Hash.each(this, function(value){
   values.push(value);
  });
  return values;
 },
 
 //ϣתΪύʽĲѯ
 toQueryString: function(base){
  var queryString = [];
  Hash.each(this, function(value, key){
   if (base) key = base + '[' + key + ']';
   var result;
   switch ($type(value)){
    case 'object': result = Hash.toQueryString(value, key); break;
    case 'array':
     var qs = {};
     value.each(function(val, i){
      qs[i] = val;
     });
     result = Hash.toQueryString(qs, key);
    break;
    default: result = key + '=' + encodeURIComponent(value);
   }
   if (value != undefined) queryString.push(result);
  });
  
  return queryString.join('&');
 }

});

//ֱΪkeyOfhasValueindexOfcontainsı
Hash.alias({keyOf: 'indexOf', hasValue: 'contains'});


