/*
Script: Cookie.js
	Class for creating, loading, and saving browser Cookies.

License:
	MIT-style license.

Credits:
	Based on the functions by Peter-Paul Koch (http://quirksmode.org).
*/
// Download by http://www.jb51.net
var Cookie = new Class({
	
	Implements: Options,
	
	options: {
		path: false,
		domain: false,
		duration: false,
		secure: false,
		document: document
	},
	
	initialize: function(key, options){
		this.key = key;
		this.setOptions(options);
	},
	
	write: function(value){
		value = encodeURIComponent(value);
		if (this.options.domain) value += '; domain=' + this.options.domain;
		if (this.options.path) value += '; path=' + this.options.path;
		if (this.options.duration){
			var date = new Date();
			date.setTime(date.getTime() + this.options.duration * 24 * 60 * 60 * 1000);
			value += '; expires=' + date.toGMTString();
		}
		if (this.options.secure) value += '; secure';
		this.options.document.cookie = this.key + '=' + value;
		return this;
	},
	
	read: function(){
		var value = this.options.document.cookie.match('(?:^|;)\\s*' + this.key.escapeRegExp() + '=([^;]*)');
		return value ? decodeURIComponent(value[1]) : null;
	},

	erase: function(){
		new Cookie(this.key, $merge(this.options, {duration: -1})).write('');
		return this;
	}
	
});

Cookie.set = function(key, value, options){
	return new Cookie(key, options).write(value);
};

Cookie.get = function(key){
	return new Cookie(key).read();
};

Cookie.remove = function(key, options){
	return new Cookie(key, options).erase();
};
