<div class="page-header">
    <ul>
        <li><i class="fa fa-users fa-fw"></i><?= $this->url->link(t('View all groups'), 'Admin/GroupController', 'index') ?></li>
        <li><i class="fa fa-plus fa-fw"></i><?= $this->url->link(t('Add group member'), 'Admin/GroupController', 'associate', ['group_id' => $group['id']], false, 'popover') ?></li>
    </ul>
</div>
<?php if ($paginator->isEmpty()): ?>
    <p class="alert"><?= t('There is no user in this group.') ?></p>
<?php else: ?>
    <table class="table-striped table-scrolling">
        <tr>
            <th><?= $paginator->order(t('Id'), 'id') ?></th>
            <th><?= $paginator->order(t('Username'), 'username') ?></th>
            <th><?= $paginator->order(t('Name'), 'name') ?></th>
            <th><?= $paginator->order(t('Email'), 'email') ?></th>
            <th><?= t('Actions') ?></th>
        </tr>
        <?php foreach ($paginator->getCollection() as $user): ?>
        <tr>
            <td>
                <?= $this->url->link('#'.$user['id'], 'Profile/ProfileController', 'show', ['user_id' => $user['id']]) ?>
            </td>
            <td>
                <?= $this->url->link($this->text->e($user['username']), 'Profile/ProfileController', 'show', ['user_id' => $user['id']]) ?>
            </td>
            <td>
                <?= $this->text->e($user['name']) ?>
            </td>
            <td>
                <a href="mailto:<?= $this->text->e($user['email']) ?>"><?= $this->text->e($user['email']) ?></a>
            </td>
            <td>
                <i class="fa fa-times fa-fw" aria-hidden="true"></i>
                <?= $this->url->link(t('Remove this user'), 'Admin/GroupController', 'dissociate', ['group_id' => $group['id'], 'user_id' => $user['id']], false, 'popover') ?>
            </td>
        </tr>
        <?php endforeach ?>
    </table>

    <div class="page-footer">
        <?= $paginator ?>
    </div>
<?php endif ?>
