/**
 * @license
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import {html} from '@polymer/polymer/lib/utils/html-tag';

export const htmlTemplate = html`
  <!-- TODO(taoalpha): move all shared styles to a style module. -->
  <style include="shared-styles">
    :host {
      display: block;
    }
    :host([disabled]) {
      opacity: 0.5;
      pointer-events: none;
    }
    label {
      cursor: pointer;
      display: block;
      width: 100%;
    }
    iron-autogrow-textarea {
      font-family: var(--monospace-font-family);
      font-size: var(--font-size-mono);
      line-height: var(--line-height-mono);
      width: 73ch; /* Add a char to account for the border. */
    }
  </style>
  <gr-dialog
    confirm-label="Revert Submission"
    on-confirm="_handleConfirmTap"
    on-cancel="_handleCancelTap"
  >
    <div class="header" slot="header">Revert Submission</div>
    <div class="main" slot="main">
      <label for="messageInput"> Revert Commit Message </label>
      <iron-autogrow-textarea
        id="messageInput"
        class="message"
        autocomplete="on"
        max-rows="15"
        bind-value="{{message}}"
      ></iron-autogrow-textarea>
    </div>
  </gr-dialog>
`;
