/**
 * @license
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import '../../../styles/shared-styles';
import '../gr-copy-clipboard/gr-copy-clipboard';
import {PolymerElement} from '@polymer/polymer/polymer-element';
import {htmlTemplate} from './gr-shell-command_html';
import {customElement, property} from '@polymer/decorators';

declare global {
  interface HTMLElementTagNameMap {
    'gr-shell-command': GrShellCommand;
  }
}

@customElement('gr-shell-command')
class GrShellCommand extends PolymerElement {
  static get template() {
    return htmlTemplate;
  }

  @property({type: String})
  command: string | undefined;

  @property({type: String})
  label: string | undefined;

  focusOnCopy() {
    if (this.shadowRoot !== null) {
      const copyClipboard = this.shadowRoot.querySelector('gr-copy-clipboard');
      if (copyClipboard !== null) {
        copyClipboard.focusOnCopy();
      }
    }
  }
}
