/**
 * @license
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import '../../../test/common-test-setup-karma.js';
import './revision-info.js';
import {RevisionInfo} from './revision-info.js';
suite('revision-info tests', () => {
  let mockChange;

  setup(() => {
    mockChange = {
      revisions: {
        r1: {_number: 1, commit: {parents: [
          {commit: 'p1'},
          {commit: 'p2'},
          {commit: 'p3'},
        ]}},
        r2: {_number: 2, commit: {parents: [
          {commit: 'p1'},
          {commit: 'p4'},
        ]}},
        r3: {_number: 3, commit: {parents: [{commit: 'p5'}]}},
        r4: {_number: 4, commit: {parents: [
          {commit: 'p2'},
          {commit: 'p3'},
        ]}},
        r5: {_number: 5, commit: {parents: [
          {commit: 'p5'},
          {commit: 'p2'},
          {commit: 'p3'},
        ]}},
      },
    };
  });

  test('getMaxParents', () => {
    const ri = new RevisionInfo(mockChange);
    assert.equal(ri.getMaxParents(), 3);
  });

  test('getParentCountMap', () => {
    const ri = new RevisionInfo(mockChange);
    assert.deepEqual(ri.getParentCountMap(), {1: 3, 2: 2, 3: 1, 4: 2, 5: 3});
  });

  test('getParentCount', () => {
    const ri = new RevisionInfo(mockChange);
    assert.deepEqual(ri.getParentCount(1), 3);
    assert.deepEqual(ri.getParentCount(3), 1);
  });

  test('getParentCount', () => {
    const ri = new RevisionInfo(mockChange);
    assert.deepEqual(ri.getParentCount(1), 3);
    assert.deepEqual(ri.getParentCount(3), 1);
  });

  test('getParentId', () => {
    const ri = new RevisionInfo(mockChange);
    assert.deepEqual(ri.getParentId(1, 2), 'p3');
    assert.deepEqual(ri.getParentId(2, 1), 'p4');
    assert.deepEqual(ri.getParentId(3, 0), 'p5');
  });
});

